/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.insert;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.mybatis.dynamic.sql.SqlColumn;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.insert.GeneralInsertModel;
import org.mybatis.dynamic.sql.util.AbstractColumnMapping;
import org.mybatis.dynamic.sql.util.Buildable;
import org.mybatis.dynamic.sql.util.ConstantMapping;
import org.mybatis.dynamic.sql.util.NullMapping;
import org.mybatis.dynamic.sql.util.StringConstantMapping;
import org.mybatis.dynamic.sql.util.ValueMapping;
import org.mybatis.dynamic.sql.util.ValueOrNullMapping;
import org.mybatis.dynamic.sql.util.ValueWhenPresentMapping;

public class GeneralInsertDSL
implements Buildable<GeneralInsertModel> {
    private final List<AbstractColumnMapping> insertMappings = new ArrayList<AbstractColumnMapping>();
    private final SqlTable table;

    private GeneralInsertDSL(SqlTable table) {
        this.table = Objects.requireNonNull(table);
    }

    public <T> SetClauseFinisher<T> set(SqlColumn<T> column) {
        return new SetClauseFinisher<T>(column);
    }

    @Override
    @NotNull
    public GeneralInsertModel build() {
        return new GeneralInsertModel.Builder().withTable(this.table).withInsertMappings(this.insertMappings).build();
    }

    public static GeneralInsertDSL insertInto(SqlTable table) {
        return new GeneralInsertDSL(table);
    }

    public class SetClauseFinisher<T> {
        private final SqlColumn<T> column;

        public SetClauseFinisher(SqlColumn<T> column) {
            this.column = column;
        }

        public GeneralInsertDSL toNull() {
            GeneralInsertDSL.this.insertMappings.add(NullMapping.of(this.column));
            return GeneralInsertDSL.this;
        }

        public GeneralInsertDSL toConstant(String constant) {
            GeneralInsertDSL.this.insertMappings.add(ConstantMapping.of(this.column, constant));
            return GeneralInsertDSL.this;
        }

        public GeneralInsertDSL toStringConstant(String constant) {
            GeneralInsertDSL.this.insertMappings.add(StringConstantMapping.of(this.column, constant));
            return GeneralInsertDSL.this;
        }

        public GeneralInsertDSL toValue(T value) {
            return this.toValue(() -> value);
        }

        public GeneralInsertDSL toValue(Supplier<T> valueSupplier) {
            GeneralInsertDSL.this.insertMappings.add(ValueMapping.of(this.column, valueSupplier));
            return GeneralInsertDSL.this;
        }

        public GeneralInsertDSL toValueOrNull(T value) {
            return this.toValueOrNull(() -> value);
        }

        public GeneralInsertDSL toValueOrNull(Supplier<T> valueSupplier) {
            GeneralInsertDSL.this.insertMappings.add(ValueOrNullMapping.of(this.column, valueSupplier));
            return GeneralInsertDSL.this;
        }

        public GeneralInsertDSL toValueWhenPresent(T value) {
            return this.toValueWhenPresent(() -> value);
        }

        public GeneralInsertDSL toValueWhenPresent(Supplier<T> valueSupplier) {
            GeneralInsertDSL.this.insertMappings.add(ValueWhenPresentMapping.of(this.column, valueSupplier));
            return GeneralInsertDSL.this;
        }
    }
}

