/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.where.condition;

import java.util.Collection;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mybatis.dynamic.sql.AbstractListValueCondition;
import org.mybatis.dynamic.sql.util.StringUtilities;

public class IsNotInCaseInsensitive
extends AbstractListValueCondition<String> {
    protected IsNotInCaseInsensitive(Collection<String> values) {
        super(values, s -> s.map(StringUtilities::safelyUpperCase));
    }

    protected IsNotInCaseInsensitive(Collection<String> values, UnaryOperator<Stream<String>> valueStreamTransformer) {
        super(values, StringUtilities.upperCaseAfter(valueStreamTransformer));
    }

    @Override
    public String renderCondition(String columnName, Stream<String> placeholders) {
        return "upper(" + columnName + ") " + placeholders.collect(Collectors.joining(",", "not in (", ")"));
    }

    public IsNotInCaseInsensitive then(UnaryOperator<Stream<String>> valueStreamTransformer) {
        return new IsNotInCaseInsensitive(this.values, valueStreamTransformer);
    }

    @Deprecated
    public IsNotInCaseInsensitive withValueStreamOperations(UnaryOperator<Stream<String>> valueStreamTransformer) {
        return this.then(valueStreamTransformer);
    }

    public static IsNotInCaseInsensitive of(Collection<String> values) {
        return new IsNotInCaseInsensitive(values);
    }
}

