/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.update.render;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.SqlColumn;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.render.TableAliasCalculator;
import org.mybatis.dynamic.sql.select.render.SelectRenderer;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.mybatis.dynamic.sql.util.ColumnMapping;
import org.mybatis.dynamic.sql.util.ConstantMapping;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.NullMapping;
import org.mybatis.dynamic.sql.util.SelectMapping;
import org.mybatis.dynamic.sql.util.StringConstantMapping;
import org.mybatis.dynamic.sql.util.UpdateMappingVisitor;
import org.mybatis.dynamic.sql.util.ValueMapping;

public class SetPhraseVisitor
implements UpdateMappingVisitor<FragmentAndParameters> {
    private AtomicInteger sequence;
    private RenderingStrategy renderingStrategy;

    public SetPhraseVisitor(AtomicInteger sequence, RenderingStrategy renderingStrategy) {
        this.sequence = Objects.requireNonNull(sequence);
        this.renderingStrategy = Objects.requireNonNull(renderingStrategy);
    }

    @Override
    public FragmentAndParameters visit(NullMapping mapping) {
        return FragmentAndParameters.withFragment(mapping.mapColumn(SqlColumn::name) + " = null").build();
    }

    @Override
    public FragmentAndParameters visit(ConstantMapping mapping) {
        String fragment = mapping.mapColumn(SqlColumn::name) + " = " + mapping.constant();
        return FragmentAndParameters.withFragment(fragment).build();
    }

    @Override
    public FragmentAndParameters visit(StringConstantMapping mapping) {
        String fragment = mapping.mapColumn(SqlColumn::name) + " = '" + mapping.constant() + "'";
        return FragmentAndParameters.withFragment(fragment).build();
    }

    @Override
    public <T> FragmentAndParameters visit(ValueMapping<T> mapping) {
        String mapKey = "p" + this.sequence.getAndIncrement();
        String jdbcPlaceholder = mapping.mapColumn(this.toJdbcPlaceholder(mapKey));
        String setPhrase = mapping.mapColumn(SqlColumn::name) + " = " + jdbcPlaceholder;
        return FragmentAndParameters.withFragment(setPhrase).withParameter(mapKey, mapping.value()).build();
    }

    @Override
    public FragmentAndParameters visit(SelectMapping mapping) {
        SelectStatementProvider selectStatement = SelectRenderer.withSelectModel(mapping.selectModel()).withRenderingStrategy(this.renderingStrategy).withSequence(this.sequence).build().render();
        String fragment = mapping.mapColumn(SqlColumn::name) + " = (" + selectStatement.getSelectStatement() + ")";
        return FragmentAndParameters.withFragment(fragment).withParameters(selectStatement.getParameters()).build();
    }

    @Override
    public FragmentAndParameters visit(ColumnMapping mapping) {
        String setPhrase = mapping.mapColumn(SqlColumn::name) + " = " + mapping.rightColumn().renderWithTableAlias(TableAliasCalculator.empty());
        return FragmentAndParameters.withFragment(setPhrase).build();
    }

    private Function<SqlColumn<?>, String> toJdbcPlaceholder(String parameterName) {
        return column -> this.renderingStrategy.getFormattedJdbcPlaceholder((BindableColumn<?>)column, "parameters", parameterName);
    }
}

