/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.update;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.update.render.UpdateRenderer;
import org.mybatis.dynamic.sql.update.render.UpdateStatementProvider;
import org.mybatis.dynamic.sql.util.UpdateMapping;
import org.mybatis.dynamic.sql.where.WhereModel;

public class UpdateModel {
    private SqlTable table;
    private WhereModel whereModel;
    private List<UpdateMapping> columnMappings;

    private UpdateModel(Builder builder) {
        this.table = Objects.requireNonNull(builder.table);
        this.whereModel = builder.whereModel;
        this.columnMappings = Objects.requireNonNull(builder.columnMappings);
    }

    public SqlTable table() {
        return this.table;
    }

    public Optional<WhereModel> whereModel() {
        return Optional.ofNullable(this.whereModel);
    }

    public <R> Stream<R> mapColumnMappings(Function<UpdateMapping, R> mapper) {
        return this.columnMappings.stream().map(mapper);
    }

    public UpdateStatementProvider render(RenderingStrategy renderingStrategy) {
        return UpdateRenderer.withUpdateModel(this).withRenderingStrategy(renderingStrategy).build().render();
    }

    public static Builder withTable(SqlTable table) {
        return new Builder().withTable(table);
    }

    public static class Builder {
        private SqlTable table;
        private WhereModel whereModel;
        private List<UpdateMapping> columnMappings = new ArrayList<UpdateMapping>();

        public Builder withTable(SqlTable table) {
            this.table = table;
            return this;
        }

        public Builder withColumnMappings(List<UpdateMapping> columnMappings) {
            this.columnMappings.addAll(columnMappings);
            return this;
        }

        public Builder withWhereModel(WhereModel whereModel) {
            this.whereModel = whereModel;
            return this;
        }

        public UpdateModel build() {
            return new UpdateModel(this);
        }
    }
}

