/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.render;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.select.GroupByModel;
import org.mybatis.dynamic.sql.select.QueryExpressionModel;
import org.mybatis.dynamic.sql.select.join.JoinModel;
import org.mybatis.dynamic.sql.select.render.JoinRenderer;
import org.mybatis.dynamic.sql.util.CustomCollectors;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.StringUtilities;
import org.mybatis.dynamic.sql.where.WhereModel;
import org.mybatis.dynamic.sql.where.render.WhereClauseProvider;
import org.mybatis.dynamic.sql.where.render.WhereRenderer;

public class QueryExpressionRenderer {
    private QueryExpressionModel queryExpression;
    private RenderingStrategy renderingStrategy;
    private AtomicInteger sequence;

    private QueryExpressionRenderer(Builder builder) {
        this.queryExpression = Objects.requireNonNull(builder.queryExpression);
        this.renderingStrategy = Objects.requireNonNull(builder.renderingStrategy);
        this.sequence = Objects.requireNonNull(builder.sequence);
    }

    public FragmentAndParameters render() {
        Optional<WhereClauseProvider> whereClause = this.queryExpression.whereModel().flatMap(this::renderWhereClause);
        return FragmentAndParameters.withFragment(this.calculateQueryExpression(whereClause)).withParameters(this.calculateParameters(whereClause)).build();
    }

    private String calculateQueryExpression(Optional<WhereClauseProvider> whereClause) {
        return StringUtilities.spaceAfter(this.queryExpression.connector()) + "select " + (this.queryExpression.isDistinct() ? "distinct " : "") + this.calculateColumnList() + " from " + this.calculateTableName(this.queryExpression.table()) + StringUtilities.spaceBefore(this.queryExpression.joinModel().map(this::renderJoin)) + StringUtilities.spaceBefore(whereClause.map(WhereClauseProvider::getWhereClause)) + StringUtilities.spaceBefore(this.queryExpression.groupByModel().map(this::renderGroupBy));
    }

    private Map<String, Object> calculateParameters(Optional<WhereClauseProvider> whereClause) {
        return whereClause.map(WhereClauseProvider::getParameters).orElse(Collections.emptyMap());
    }

    private String calculateColumnList() {
        return this.queryExpression.mapColumns(this::applyTableAndColumnAlias).collect(Collectors.joining(", "));
    }

    private String calculateTableName(SqlTable table) {
        return this.queryExpression.calculateTableNameIncludingAlias(table);
    }

    private String applyTableAndColumnAlias(BasicColumn selectListItem) {
        return selectListItem.renderWithTableAndColumnAlias(this.queryExpression.tableAliasCalculator());
    }

    private String renderJoin(JoinModel joinModel) {
        return JoinRenderer.withJoinModel(joinModel).withQueryExpression(this.queryExpression).build().render();
    }

    private Optional<WhereClauseProvider> renderWhereClause(WhereModel whereModel) {
        return WhereRenderer.withWhereModel(whereModel).withRenderingStrategy(this.renderingStrategy).withTableAliasCalculator(this.queryExpression.tableAliasCalculator()).withSequence(this.sequence).build().render();
    }

    private String renderGroupBy(GroupByModel groupByModel) {
        return groupByModel.mapColumns(this::applyTableAlias).collect(CustomCollectors.joining(", ", "group by ", ""));
    }

    private String applyTableAlias(BasicColumn column) {
        return column.renderWithTableAlias(this.queryExpression.tableAliasCalculator());
    }

    public static Builder withQueryExpression(QueryExpressionModel model) {
        return new Builder().withQueryExpression(model);
    }

    public static class Builder {
        private QueryExpressionModel queryExpression;
        private RenderingStrategy renderingStrategy;
        private AtomicInteger sequence;

        public Builder withQueryExpression(QueryExpressionModel queryExpression) {
            this.queryExpression = queryExpression;
            return this;
        }

        public Builder withRenderingStrategy(RenderingStrategy renderingStrategy) {
            this.renderingStrategy = renderingStrategy;
            return this;
        }

        public Builder withSequence(AtomicInteger sequence) {
            this.sequence = sequence;
            return this;
        }

        public QueryExpressionRenderer build() {
            return new QueryExpressionRenderer(this);
        }
    }
}

