/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.render;

import java.util.Objects;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.select.QueryExpressionModel;
import org.mybatis.dynamic.sql.select.join.JoinCriterion;
import org.mybatis.dynamic.sql.select.join.JoinModel;
import org.mybatis.dynamic.sql.select.join.JoinSpecification;
import org.mybatis.dynamic.sql.util.StringUtilities;

public class JoinRenderer {
    private JoinModel joinModel;
    private QueryExpressionModel queryExpression;

    private JoinRenderer(Builder builder) {
        this.joinModel = Objects.requireNonNull(builder.joinModel);
        this.queryExpression = Objects.requireNonNull(builder.queryExpression);
    }

    public String render() {
        return this.joinModel.mapJoinSpecifications(this::toRenderedString).collect(Collectors.joining(" "));
    }

    private String toRenderedString(JoinSpecification joinSpecification) {
        return StringUtilities.spaceAfter(joinSpecification.joinType().shortType()) + "join" + StringUtilities.spaceBefore(this.queryExpression.calculateTableNameIncludingAlias(joinSpecification.table())) + StringUtilities.spaceBefore(this.renderConditions(joinSpecification));
    }

    private String renderConditions(JoinSpecification joinSpecification) {
        return joinSpecification.mapJoinCriteria(this::renderCriterion).collect(Collectors.joining(" "));
    }

    private String renderCriterion(JoinCriterion joinCriterion) {
        return joinCriterion.connector() + StringUtilities.spaceBefore(this.applyTableAlias(joinCriterion.leftColumn())) + StringUtilities.spaceBefore(joinCriterion.operator()) + StringUtilities.spaceBefore(this.applyTableAlias(joinCriterion.rightColumn()));
    }

    private String applyTableAlias(BasicColumn column) {
        return column.renderWithTableAlias(this.queryExpression.tableAliasCalculator());
    }

    public static Builder withJoinModel(JoinModel joinModel) {
        return new Builder().withJoinModel(joinModel);
    }

    public static class Builder {
        private JoinModel joinModel;
        private QueryExpressionModel queryExpression;

        public Builder withJoinModel(JoinModel joinModel) {
            this.joinModel = joinModel;
            return this;
        }

        public Builder withQueryExpression(QueryExpressionModel queryExpression) {
            this.queryExpression = queryExpression;
            return this;
        }

        public JoinRenderer build() {
            return new JoinRenderer(this);
        }
    }
}

