/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.render;

import java.util.Optional;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.select.FetchFirstPagingModel;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;

public class FetchFirstPagingModelRenderer {
    private static final String FETCH_FIRST_ROWS_PARAMETER = "_fetchFirstRows";
    private static final String OFFSET_PARAMETER = "_offset";
    private RenderingStrategy renderingStrategy;
    private FetchFirstPagingModel pagingModel;

    public FetchFirstPagingModelRenderer(RenderingStrategy renderingStrategy, FetchFirstPagingModel pagingModel) {
        this.renderingStrategy = renderingStrategy;
        this.pagingModel = pagingModel;
    }

    public Optional<FragmentAndParameters> render() {
        return this.pagingModel.offset().map(this::renderWithOffset).orElseGet(this::renderFetchFirstRowsOnly);
    }

    private Optional<FragmentAndParameters> renderWithOffset(Long offset) {
        return this.pagingModel.fetchFirstRows().map(ffr -> this.renderOffsetAndFetchFirstRows(offset, (Long)ffr)).orElseGet(() -> this.renderOffsetOnly(offset));
    }

    private Optional<FragmentAndParameters> renderFetchFirstRowsOnly() {
        return this.pagingModel.fetchFirstRows().flatMap(this::renderFetchFirstRowsOnly);
    }

    private Optional<FragmentAndParameters> renderFetchFirstRowsOnly(Long fetchFirstRows) {
        return FragmentAndParameters.withFragment("fetch first " + this.renderPlaceholder(FETCH_FIRST_ROWS_PARAMETER) + " rows only").withParameter(FETCH_FIRST_ROWS_PARAMETER, fetchFirstRows).buildOptional();
    }

    private Optional<FragmentAndParameters> renderOffsetOnly(Long offset) {
        return FragmentAndParameters.withFragment("offset " + this.renderPlaceholder(OFFSET_PARAMETER) + " rows").withParameter(OFFSET_PARAMETER, offset).buildOptional();
    }

    private Optional<FragmentAndParameters> renderOffsetAndFetchFirstRows(Long offset, Long fetchFirstRows) {
        return FragmentAndParameters.withFragment("offset " + this.renderPlaceholder(OFFSET_PARAMETER) + " rows fetch first " + this.renderPlaceholder(FETCH_FIRST_ROWS_PARAMETER) + " rows only").withParameter(OFFSET_PARAMETER, offset).withParameter(FETCH_FIRST_ROWS_PARAMETER, fetchFirstRows).buildOptional();
    }

    private String renderPlaceholder(String parameterName) {
        return this.renderingStrategy.getFormattedJdbcPlaceholder("parameters", parameterName);
    }
}

