/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.render;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;

public class DefaultSelectStatementProvider
implements SelectStatementProvider {
    private String selectStatement;
    private Map<String, Object> parameters;

    private DefaultSelectStatementProvider(Builder builder) {
        this.selectStatement = Objects.requireNonNull(builder.selectStatement);
        this.parameters = Collections.unmodifiableMap(Objects.requireNonNull(builder.parameters));
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public String getSelectStatement() {
        return this.selectStatement;
    }

    public static Builder withSelectStatement(String selectStatement) {
        return new Builder().withSelectStatement(selectStatement);
    }

    public static class Builder {
        private String selectStatement;
        private Map<String, Object> parameters = new HashMap<String, Object>();

        public Builder withSelectStatement(String selectStatement) {
            this.selectStatement = selectStatement;
            return this;
        }

        public Builder withParameters(Map<String, Object> parameters) {
            this.parameters.putAll(parameters);
            return this;
        }

        public DefaultSelectStatementProvider build() {
            return new DefaultSelectStatementProvider(this);
        }
    }
}

