/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.insert.render;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.insert.render.FieldAndValue;

public class FieldAndValueCollector<T> {
    private List<String> columnNames = new ArrayList<String>();
    private List<String> valuePhrases = new ArrayList<String>();

    public void add(FieldAndValue fieldAndValue) {
        this.columnNames.add(fieldAndValue.fieldName());
        this.valuePhrases.add(fieldAndValue.valuePhrase());
    }

    public FieldAndValueCollector<T> merge(FieldAndValueCollector<T> other) {
        this.columnNames.addAll(other.columnNames);
        this.valuePhrases.addAll(other.valuePhrases);
        return this;
    }

    public String columnsPhrase() {
        return this.columnNames.stream().collect(Collectors.joining(", ", "(", ")"));
    }

    public String valuesPhrase() {
        return this.valuePhrases.stream().collect(Collectors.joining(", ", "values (", ")"));
    }

    public static <T> Collector<FieldAndValue, FieldAndValueCollector<T>, FieldAndValueCollector<T>> collect() {
        return Collector.of(FieldAndValueCollector::new, FieldAndValueCollector::add, FieldAndValueCollector::merge, new Collector.Characteristics[0]);
    }
}

