/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.insert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.insert.render.BatchInsert;
import org.mybatis.dynamic.sql.insert.render.BatchInsertRenderer;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.util.InsertMapping;

public class BatchInsertModel<T> {
    private SqlTable table;
    private List<T> records;
    private List<InsertMapping> columnMappings;

    private BatchInsertModel(Builder<T> builder) {
        this.table = Objects.requireNonNull(((Builder)builder).table);
        this.records = Collections.unmodifiableList(Objects.requireNonNull(((Builder)builder).records));
        this.columnMappings = Objects.requireNonNull(((Builder)builder).columnMappings);
    }

    public <R> Stream<R> mapColumnMappings(Function<InsertMapping, R> mapper) {
        return this.columnMappings.stream().map(mapper);
    }

    public List<T> records() {
        return this.records;
    }

    public SqlTable table() {
        return this.table;
    }

    public BatchInsert<T> render(RenderingStrategy renderingStrategy) {
        return BatchInsertRenderer.withBatchInsertModel(this).withRenderingStrategy(renderingStrategy).build().render();
    }

    public static <T> Builder<T> withRecords(Collection<T> records) {
        return new Builder<T>().withRecords(records);
    }

    public static class Builder<T> {
        private SqlTable table;
        private List<T> records = new ArrayList<T>();
        private List<InsertMapping> columnMappings = new ArrayList<InsertMapping>();

        public Builder<T> withTable(SqlTable table) {
            this.table = table;
            return this;
        }

        public Builder<T> withRecords(Collection<T> records) {
            this.records.addAll(records);
            return this;
        }

        public Builder<T> withColumnMappings(List<InsertMapping> columnMappings) {
            this.columnMappings.addAll(columnMappings);
            return this;
        }

        public BatchInsertModel<T> build() {
            return new BatchInsertModel(this);
        }
    }
}

