/*
 * Decompiled with CFR 0.152.
 */
package org.mvnpm.importmap;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mvnpm.importmap.model.Imports;

public class Aggregator {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Map<String, String> userProvidedImports = new HashMap<String, String>();
    private final Set<URL> userProvidedJarUrls = new HashSet<URL>();

    public Aggregator() {
    }

    public Aggregator(Set<URL> urls) {
        this.userProvidedJarUrls.addAll(urls);
    }

    public Aggregator(Map<String, String> importMapings) {
        this.userProvidedImports.putAll(importMapings);
    }

    public Aggregator(Set<URL> urls, Map<String, String> importMapings) {
        this.userProvidedJarUrls.addAll(urls);
        this.userProvidedImports.putAll(importMapings);
    }

    public void addMapping(String key, String value) {
        this.userProvidedImports.put(key, value);
    }

    public void addMappings(Map<String, String> all) {
        this.userProvidedImports.putAll(all);
    }

    public void addJarUrl(URL url) {
        this.userProvidedJarUrls.add(url);
    }

    public void addJarUrls(Set<URL> urls) {
        this.userProvidedJarUrls.addAll(urls);
    }

    public Imports aggregate() {
        return this.aggregate("");
    }

    public Imports aggregate(String root) {
        if (root.endsWith("/")) {
            root = root.substring(0, root.length() - 1);
        }
        HashMap<String, String> allimports = new HashMap<String, String>();
        allimports.putAll(this.userProvidedImports);
        allimports.putAll(this.scanUserProviderUrls(root));
        allimports.putAll(this.scanClassPath(root));
        return new Imports(allimports);
    }

    public String aggregateAsJson() {
        return this.aggregateAsJson("");
    }

    public String aggregateAsJson(String root) {
        try {
            Imports i = this.aggregate(root);
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)i);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void reset() {
        this.userProvidedImports.clear();
        this.userProvidedJarUrls.clear();
    }

    private Map<String, String> scanUserProviderUrls(String root) {
        if (!this.userProvidedJarUrls.isEmpty()) {
            URLClassLoader urlClassLoader = new URLClassLoader(this.userProvidedJarUrls.toArray(new URL[0]));
            try {
                Enumeration<URL> enumer = urlClassLoader.getResources("META-INF/importmap.json");
                HashMap<String, String> m = new HashMap<String, String>();
                while (enumer.hasMoreElements()) {
                    URL importmapFile = enumer.nextElement();
                    Imports importsForPackage = (Imports)this.objectMapper.readValue(importmapFile, Imports.class);
                    Map<String, String> importForPackage = importsForPackage.getImports();
                    for (Map.Entry<String, String> kv : importForPackage.entrySet()) {
                        m.put(kv.getKey(), root + kv.getValue());
                    }
                }
                return m;
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Could not aggregate importmaps from set of urls", ex);
            }
        }
        return Map.of();
    }

    private Map<String, String> scanClassPath(String root) {
        try {
            Enumeration<URL> enumer = Thread.currentThread().getContextClassLoader().getResources("META-INF/importmap.json");
            HashMap<String, String> m = new HashMap<String, String>();
            while (enumer.hasMoreElements()) {
                URL importmapFile = enumer.nextElement();
                Imports importsForPackage = (Imports)this.objectMapper.readValue(importmapFile, Imports.class);
                Map<String, String> importForPackage = importsForPackage.getImports();
                for (Map.Entry<String, String> kv : importForPackage.entrySet()) {
                    m.put(kv.getKey(), root + kv.getValue());
                }
            }
            return m;
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Could not aggregate importmaps from classpath", ex);
        }
    }
}

