/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.optimizers.impl.refl.nodes;

import java.lang.reflect.Method;
import org.mvel2.CompileException;
import org.mvel2.MVEL;
import org.mvel2.compiler.AccessorNode;
import org.mvel2.integration.PropertyHandler;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.util.ParseTools;

public class GetterAccessorNH
implements AccessorNode {
    private AccessorNode nextNode;
    private final Method method;
    private PropertyHandler nullHandler;
    public static final Object[] EMPTY = new Object[0];

    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory vars) {
        try {
            return this.nullHandle(this.method.getName(), this.method.invoke(ctx, EMPTY), ctx, elCtx, vars);
        }
        catch (IllegalArgumentException e) {
            Method o;
            if (ctx != null && this.method.getDeclaringClass() != ctx.getClass() && (o = ParseTools.getBestCandidate(EMPTY, this.method.getName(), ctx.getClass(), ctx.getClass().getMethods(), true)) != null) {
                return this.executeOverrideTarget(o, ctx, elCtx, vars);
            }
            return this.nullHandle(this.method.getName(), MVEL.getProperty(this.method.getName() + "()", ctx), ctx, elCtx, vars);
        }
        catch (Exception e) {
            throw new RuntimeException("cannot invoke getter: " + this.method.getName() + " [declr.class: " + this.method.getDeclaringClass().getName() + "; act.class: " + (ctx != null ? ctx.getClass().getName() : "null") + "]", e);
        }
    }

    public GetterAccessorNH(Method method, PropertyHandler nullHandler) {
        this.method = method;
        this.nullHandler = nullHandler;
    }

    public Method getMethod() {
        return this.method;
    }

    public AccessorNode setNextNode(AccessorNode nextNode) {
        this.nextNode = nextNode;
        return this.nextNode;
    }

    public AccessorNode getNextNode() {
        return this.nextNode;
    }

    public String toString() {
        return this.method.getDeclaringClass().getName() + "." + this.method.getName();
    }

    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory vars, Object value) {
        try {
            Object v = this.method.invoke(ctx, EMPTY);
            if (v == null) {
                v = this.nullHandler.getProperty(this.method.getName(), ctx, vars);
            }
            return this.nextNode.setValue(v, elCtx, vars, value);
        }
        catch (IllegalArgumentException e) {
            Object v = MVEL.getProperty(this.method.getName() + "()", ctx);
            if (v == null) {
                v = this.nullHandler.getProperty(this.method.getName(), ctx, vars);
            }
            return this.nextNode.setValue(v, elCtx, vars, value);
        }
        catch (CompileException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("error " + this.method.getName() + ": " + e.getClass().getName() + ":" + e.getMessage(), e);
        }
    }

    public Class getKnownEgressType() {
        return this.method.getReturnType();
    }

    private Object executeOverrideTarget(Method o, Object ctx, Object elCtx, VariableResolverFactory vars) {
        try {
            return this.nullHandle(o.getName(), o.invoke(ctx, EMPTY), ctx, elCtx, vars);
        }
        catch (Exception e2) {
            throw new RuntimeException("unable to invoke method", e2);
        }
    }

    private Object nullHandle(String name, Object v, Object ctx, Object elCtx, VariableResolverFactory vars) {
        if (v != null) {
            if (this.nextNode != null) {
                return this.nextNode.getValue(v, elCtx, vars);
            }
            return v;
        }
        if (this.nextNode != null) {
            return this.nextNode.getValue(this.nullHandler.getProperty(name, ctx, vars), elCtx, vars);
        }
        return this.nullHandler.getProperty(name, ctx, vars);
    }
}

