/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.tck;

import java.io.IOException;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.functional.api.component.ThrowProcessor;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.TypedException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class ThrowProcessorTestCase
extends AbstractMuleContextTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private ThrowProcessor throwProcessor = new ThrowProcessor();

    @Before
    public void setUp() throws MuleException {
        muleContext.getInjector().inject((Object)this.throwProcessor);
    }

    @Test
    public void throwsExceptionIfNoError() throws MuleException {
        this.throwProcessor.setException(TestException.class);
        this.expectedException.expect(TestException.class);
        this.expectedException.expectCause(IsInstanceOf.instanceOf(IOException.class));
        this.expectedException.expect((Matcher)new TypedExceptionErrorMatcher(Errors.ComponentIdentifiers.Handleable.EXPRESSION));
        this.throwProcessor.process((CoreEvent)Mockito.mock(CoreEvent.class));
    }

    @Test
    public void throwsTypedExceptionIfError() throws MuleException {
        this.throwProcessor.setError(Errors.ComponentIdentifiers.Handleable.SECURITY.toString());
        this.throwProcessor.setException(IllegalArgumentException.class);
        this.expectedException.expect(TypedException.class);
        this.expectedException.expectCause(IsInstanceOf.instanceOf(IllegalArgumentException.class));
        this.expectedException.expect((Matcher)new TypedExceptionErrorMatcher(Errors.ComponentIdentifiers.Handleable.SECURITY));
        this.throwProcessor.process((CoreEvent)Mockito.mock(CoreEvent.class));
    }

    private class TypedExceptionErrorMatcher
    extends TypeSafeMatcher<TypedException> {
        private ComponentIdentifier errorIdentifier;

        public TypedExceptionErrorMatcher(ComponentIdentifier errorIdentifier) {
            this.errorIdentifier = errorIdentifier;
        }

        protected boolean matchesSafely(TypedException item) {
            ErrorType errorType = item.getErrorType();
            return this.errorIdentifier.getNamespace().equals(errorType.getNamespace()) && this.errorIdentifier.getName().equals(errorType.getIdentifier());
        }

        public void describeTo(Description description) {
            description.appendText("a TypedExeption with error ");
            description.appendValue((Object)this.errorIdentifier);
        }

        protected void describeMismatchSafely(TypedException exception, Description mismatchDescription) {
            mismatchDescription.appendText("is not a TypedException with error ");
            mismatchDescription.appendValue((Object)exception.getErrorType());
        }
    }

    public static class TestException
    extends TypedException {
        public TestException() {
            super((Throwable)new IOException(), (ErrorType)muleContext.getErrorTypeRepository().lookupErrorType(Errors.ComponentIdentifiers.Handleable.EXPRESSION).get());
        }
    }
}

