/*
 * Decompiled with CFR 0.152.
 */
package org.mule.functional.api.component;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.functional.api.component.LogChecker;
import org.mule.functional.api.component.OnErrorCheckLogHandler;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.MuleException;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class OnErrorCheckLogHandlerTestCase
extends AbstractMuleTestCase {
    private static final LogChecker successfulChecker = (LogChecker)Mockito.mock(LogChecker.class);
    private static final LogChecker failingChecker = (LogChecker)Mockito.mock(LogChecker.class);
    private OnErrorCheckLogHandler checkLogHandler;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @BeforeClass
    public static void serMocks() {
        ((LogChecker)Mockito.doNothing().when((Object)successfulChecker)).check((String)Matchers.any());
        ((LogChecker)Mockito.doThrow((Throwable)((Object)new AssertionError())).when((Object)failingChecker)).check((String)Matchers.any());
    }

    @Before
    public void resetLogHandler() throws Exception {
        this.checkLogHandler = new OnErrorCheckLogHandler();
        this.checkLogHandler.setAnnotations((Map)ImmutableMap.of((Object)AbstractComponent.ROOT_CONTAINER_NAME_KEY, (Object)"someContainerName"));
        this.checkLogHandler.start();
    }

    @Test
    public void handlerFailsIfThereIsNoExceptionToHandle() throws Exception {
        this.expectedException.expect(AssertionError.class);
        this.expectedException.expectMessage("Handler could not check any exception log because no exception was raised");
        this.checkLogHandler.verify();
    }

    @Test
    public void handlerSucceedsByDefault() throws Exception {
        this.assertHandler();
    }

    @Test
    public void handlerSucceedsIfSuccessfulChecker() throws Exception {
        this.checkLogHandler.setCheckers(Arrays.asList(successfulChecker));
        this.assertHandler();
    }

    @Test
    public void handlerFailsIfFailingChecker() throws Exception {
        this.checkLogHandler.setCheckers(Arrays.asList(failingChecker));
        this.expectedException.expect(AssertionError.class);
        this.assertHandler();
    }

    @Test
    public void handlerFailsIfAtLeastOneFailingChecker() throws Exception {
        this.checkLogHandler.setCheckers(Arrays.asList(successfulChecker, successfulChecker, failingChecker, successfulChecker));
        this.expectedException.expect(AssertionError.class);
        this.assertHandler();
    }

    @Test
    public void failIfNoLogAndFlagNotSet() throws Exception {
        this.expectedException.expect(AssertionError.class);
        this.handleException();
        this.checkLogHandler.verify();
    }

    @Test
    public void succeedsIfNotLogAndFlagSet() throws Exception {
        this.checkLogHandler.setSucceedIfNoLog(true);
        this.handleException();
        this.checkLogHandler.verify();
    }

    private void assertHandler() throws Exception {
        this.handleException();
        this.checkLogHandler.doLogException(null, null);
        this.checkLogHandler.verify();
    }

    private void handleException() {
        Exception exception = (Exception)Mockito.spy(MuleException.class);
        this.checkLogHandler.route(exception);
    }
}

