/*
 * Decompiled with CFR 0.152.
 */
package org.mule.functional.api.component;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.functional.api.component.EqualsLogChecker;
import org.mule.runtime.api.exception.MuleException;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class EqualsLogCheckerTestCase
extends AbstractMuleTestCase {
    private EqualsLogChecker equalsLogChecker = new EqualsLogChecker();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void onlyEvaluatesMessage() throws Exception {
        String log = String.format("message%s%sstacktrace", System.lineSeparator(), MuleException.EXCEPTION_MESSAGE_SECTION_DELIMITER);
        this.equalsLogChecker.setExpectedLogMessage("message");
        this.equalsLogChecker.check(log);
    }

    @Test
    public void stacktraceShouldBeAvoidedEvenWithNoDelimiter() throws Exception {
        String log = String.format("first line%ssecond line%sat some.package.SomeClass.theMethod(theline:56)", System.lineSeparator(), System.lineSeparator());
        this.equalsLogChecker.setExpectedLogMessage(String.format("first line%ssecond line", System.lineSeparator()));
        this.equalsLogChecker.check(log);
    }

    @Test
    public void whitespaceDifferencesDontCauseFailureIfFilterSet() throws Exception {
        String log = String.format("  \t%s%smessage%s%s\t  ", System.lineSeparator(), System.lineSeparator(), System.lineSeparator(), System.lineSeparator());
        this.equalsLogChecker.setShouldFilterLogMessage(true);
        this.equalsLogChecker.setExpectedLogMessage("message");
        this.equalsLogChecker.check(log);
    }

    @Test
    public void whitepaceDifferencesCauseFailureIfFilterNotSet() throws Exception {
        String log = String.format("  \t%s%smessage%s%s\t  ", System.lineSeparator(), System.lineSeparator(), System.lineSeparator(), System.lineSeparator());
        this.equalsLogChecker.setShouldFilterLogMessage(false);
        this.equalsLogChecker.setExpectedLogMessage("message");
        this.expectedException.expect(AssertionError.class);
        this.equalsLogChecker.check(log);
    }

    @Test
    public void whitespaceDifferencesBeforeAndAfterSucceedWithAndWithoutFilter() throws Exception {
        String log = String.format("first line%s   second line   %s\tthird line\t", System.lineSeparator(), System.lineSeparator());
        this.equalsLogChecker.setExpectedLogMessage(String.format("first line%ssecond line%sthird line", System.lineSeparator(), System.lineSeparator()));
        this.equalsLogChecker.setShouldFilterLogMessage(false);
        this.equalsLogChecker.check(log);
        this.equalsLogChecker.setShouldFilterLogMessage(true);
        this.equalsLogChecker.check(log);
    }

    @Test
    public void delimiterDifferencesShouldSucceedWithFilter() throws Exception {
        String log = MuleException.EXCEPTION_MESSAGE_DELIMITER + "first line" + System.lineSeparator() + MuleException.EXCEPTION_MESSAGE_DELIMITER + "second line";
        this.equalsLogChecker.setShouldFilterLogMessage(true);
        this.equalsLogChecker.setExpectedLogMessage(String.format("first line%ssecond line", System.lineSeparator()));
        this.equalsLogChecker.check(log);
    }

    @Test
    public void delimiterDifferencesShouldFailWithoutFilter() throws Exception {
        String log = MuleException.EXCEPTION_MESSAGE_DELIMITER + "first line" + System.lineSeparator() + MuleException.EXCEPTION_MESSAGE_DELIMITER + "second line";
        this.equalsLogChecker.setShouldFilterLogMessage(false);
        this.equalsLogChecker.setExpectedLogMessage(String.format("first line%ssecond line", System.lineSeparator()));
        this.expectedException.expect(AssertionError.class);
        this.equalsLogChecker.check(log);
    }

    @Test
    public void filtersMessageFromStacktraceProperly() throws Exception {
        String logMessage = String.format("first line%ssecond line%s", System.lineSeparator(), System.lineSeparator());
        Exception ex1 = new Exception("exception in layer 1");
        Exception ex2 = new Exception("exception in layer 2", ex1);
        Exception ex3 = new Exception("exception in layer 3", ex2);
        StringWriter s = new StringWriter();
        PrintWriter p = new PrintWriter(s);
        ex3.printStackTrace(p);
        this.equalsLogChecker.setExpectedLogMessage(logMessage);
        this.equalsLogChecker.check(logMessage + s.toString());
    }
}

