/*
 * Decompiled with CFR 0.152.
 */
package org.mule.functional.api.component;

import java.util.concurrent.ExecutorService;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public class TestNonBlockingProcessor
extends AbstractComponent
implements Processor,
Initialisable,
Disposable,
MuleContextAware {
    private static int MAX_THREADS = 8;
    private MuleContext muleContext;
    private Scheduler customScheduler;

    public ReactiveProcessor.ProcessingType getProcessingType() {
        return ReactiveProcessor.ProcessingType.CPU_LITE_ASYNC;
    }

    public CoreEvent process(CoreEvent event) throws MuleException {
        return event;
    }

    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return Flux.from(publisher).flatMap(event -> {
            if (TransactionCoordination.isTransactionActive()) {
                return publisher;
            }
            return Flux.just((Object)event).publishOn(Schedulers.fromExecutorService((ExecutorService)this.customScheduler));
        });
    }

    public void initialise() throws InitialisationException {
        this.customScheduler = this.muleContext.getSchedulerService().customScheduler(SchedulerConfig.config().withMaxConcurrentTasks(MAX_THREADS));
    }

    public void dispose() {
        this.customScheduler.stop();
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }
}

