/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.mvel;

import java.util.Random;
import org.databene.contiperf.PerfTest;
import org.databene.contiperf.Required;
import org.databene.contiperf.junit.ContiPerfRule;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.construct.Flow;
import org.mule.el.mvel.MVELExpressionLanguage;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class MVELDeepAssignPerformanceTestCase
extends AbstractMuleContextTestCase {
    @Rule
    public ContiPerfRule rule = new ContiPerfRule();
    protected final String mel = "payload.firstName = 'Tom';payload.lastName = 'Fennelly';payload.contact.address = 'Male';payload.contact.telnum = '4';payload.sin = 'Ireland';payload;";
    protected final Payload payload = new Payload();
    protected MuleEvent event;

    public int getTestTimeoutSecs() {
        return 180;
    }

    @Before
    public void before() {
        ((MVELExpressionLanguage)muleContext.getExpressionLanguage()).setAutoResolveVariables(false);
        this.event = this.createMuleEvent();
        for (int i = 0; i < 5000; ++i) {
            muleContext.getExpressionLanguage().evaluate("payload.firstName = 'Tom';payload.lastName = 'Fennelly';payload.contact.address = 'Male';payload.contact.telnum = '4';payload.sin = 'Ireland';payload;", this.event);
        }
    }

    @Test
    @PerfTest(duration=30000, threads=1, warmUp=10000)
    @Required(median=4000)
    public void mvelColdStart() {
        for (int i = 0; i < 1000; ++i) {
            muleContext.getExpressionLanguage().evaluate("payload.firstName = 'Tom';payload.lastName = 'Fennelly';payload.contact.address = 'Male';payload.contact.telnum = '4';payload.sin = 'Ireland';payload;" + new Random().nextInt(), this.createMuleEvent());
        }
    }

    @Test
    @PerfTest(duration=30000, threads=1, warmUp=10000)
    @Required(median=25)
    public void mvelWarmStart() {
        for (int i = 0; i < 1000; ++i) {
            muleContext.getExpressionLanguage().evaluate("payload.firstName = 'Tom';payload.lastName = 'Fennelly';payload.contact.address = 'Male';payload.contact.telnum = '4';payload.sin = 'Ireland';payload;", this.event);
        }
    }

    @Test
    @PerfTest(duration=30000, threads=1, warmUp=10000)
    @Required(median=25)
    public void mvelHotStart() {
        for (int i = 0; i < 1000; ++i) {
            muleContext.getExpressionLanguage().evaluate("payload.firstName = 'Tom';payload.lastName = 'Fennelly';payload.contact.address = 'Male';payload.contact.telnum = '4';payload.sin = 'Ireland';payload;", this.event);
        }
    }

    @Ignore
    @Test
    @PerfTest(duration=30000, threads=1, warmUp=10000)
    public void createEventBaseline() {
        for (int i = 0; i < 1000; ++i) {
            this.createMuleEvent();
        }
    }

    protected MuleEvent createMuleEvent() {
        return new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)this.payload, muleContext), MessageExchangePattern.ONE_WAY, (FlowConstruct)((Flow)null));
    }

    public static class Contact {
        public String address;
        public String telnum;
    }

    public static class Payload {
        public String firstName;
        public String lastName;
        public Contact contact = new Contact();
        public String sin;
    }
}

