/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.tck;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.expression.ExpressionManager;
import org.mule.expression.DefaultExpressionManager;
import org.mule.tck.functional.AssertionMessageProcessor;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class AssertionMessageProcessorTestCase
extends AbstractMuleTestCase {
    private FlowConstruct flowConstruct;
    private ExpressionManager expressionManager;
    private MuleContext muleContext;
    private final String TRUE_EXPRESSION = "trueExpression";
    private final String FALSE_EXPRESSION = "falseExpression";

    @Before
    public void initialise() {
        this.expressionManager = (ExpressionManager)Mockito.mock(DefaultExpressionManager.class);
        Mockito.when((Object)this.expressionManager.isValidExpression(Matchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.expressionManager.evaluateBoolean((String)Matchers.eq((Object)"trueExpression"), (MuleEvent)Matchers.any(MuleEvent.class), Matchers.anyBoolean(), Matchers.anyBoolean())).thenReturn((Object)true);
        Mockito.when((Object)this.expressionManager.evaluateBoolean((String)Matchers.eq((Object)"falseExpression"), (MuleEvent)Matchers.any(MuleEvent.class), Matchers.anyBoolean(), Matchers.anyBoolean())).thenReturn((Object)false);
        this.muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        Mockito.when((Object)this.muleContext.getExpressionManager()).thenReturn((Object)this.expressionManager);
        this.flowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class);
        Mockito.when((Object)this.flowConstruct.getMuleContext()).thenReturn((Object)this.muleContext);
        Mockito.when((Object)this.flowConstruct.getName()).thenReturn((Object)"MockedFlowConstruct");
    }

    @Test
    public void startAssertionMessageProcessor() throws Exception {
        AssertionMessageProcessor asp = new AssertionMessageProcessor();
        asp.setFlowConstruct(this.flowConstruct);
        asp.start();
    }

    @Test
    public void processDummyEvent() throws Exception {
        AssertionMessageProcessor asp = new AssertionMessageProcessor();
        asp.setFlowConstruct(this.flowConstruct);
        asp.start();
        asp.process((MuleEvent)Mockito.mock(MuleEvent.class));
    }

    @Test
    public void processValidEvent() throws Exception {
        AssertionMessageProcessor asp = new AssertionMessageProcessor();
        asp.setFlowConstruct(this.flowConstruct);
        asp.setExpression("trueExpression");
        asp.start();
        asp.process((MuleEvent)Mockito.mock(MuleEvent.class));
        Assert.assertFalse((boolean)asp.expressionFailed());
        Assert.assertFalse((boolean)asp.countFailOrNullEvent());
    }

    @Test
    public void processInvalidEvent() throws Exception {
        AssertionMessageProcessor asp = new AssertionMessageProcessor();
        asp.setFlowConstruct(this.flowConstruct);
        asp.setExpression("falseExpression");
        asp.start();
        asp.process((MuleEvent)Mockito.mock(MuleEvent.class));
        Assert.assertTrue((boolean)asp.expressionFailed());
        Assert.assertFalse((boolean)asp.countFailOrNullEvent());
    }

    @Test
    public void processZeroEvents() throws Exception {
        AssertionMessageProcessor asp = new AssertionMessageProcessor();
        asp.setFlowConstruct(this.flowConstruct);
        asp.setExpression("trueExpression");
        asp.start();
        Assert.assertFalse((boolean)asp.expressionFailed());
        Assert.assertTrue((boolean)asp.countFailOrNullEvent());
    }

    @Test
    public void processSomeValidEvents() throws Exception {
        AssertionMessageProcessor asp = new AssertionMessageProcessor();
        asp.setFlowConstruct(this.flowConstruct);
        asp.setExpression("trueExpression");
        asp.start();
        asp.process((MuleEvent)Mockito.mock(MuleEvent.class));
        asp.process((MuleEvent)Mockito.mock(MuleEvent.class));
        asp.process((MuleEvent)Mockito.mock(MuleEvent.class));
        Assert.assertFalse((boolean)asp.expressionFailed());
        Assert.assertFalse((boolean)asp.countFailOrNullEvent());
    }

    @Test
    public void processSomeInvalidEvent() throws Exception {
        AssertionMessageProcessor asp = new AssertionMessageProcessor();
        asp.setFlowConstruct(this.flowConstruct);
        asp.setExpression("trueExpression");
        asp.start();
        asp.process((MuleEvent)Mockito.mock(MuleEvent.class));
        asp.process((MuleEvent)Mockito.mock(MuleEvent.class));
        asp.setExpression("falseExpression");
        asp.process((MuleEvent)Mockito.mock(MuleEvent.class));
        asp.setExpression("trueExpression");
        asp.process((MuleEvent)Mockito.mock(MuleEvent.class));
        Assert.assertTrue((boolean)asp.expressionFailed());
        Assert.assertFalse((boolean)asp.countFailOrNullEvent());
    }

    @Test
    public void processMoreThanCountEvents() throws Exception {
        AssertionMessageProcessor asp = new AssertionMessageProcessor();
        asp.setFlowConstruct(this.flowConstruct);
        asp.setExpression("trueExpression");
        asp.setCount(5);
        asp.start();
        for (int i = 0; i < 6; ++i) {
            asp.process((MuleEvent)Mockito.mock(MuleEvent.class));
        }
        Assert.assertFalse((boolean)asp.expressionFailed());
        Assert.assertTrue((boolean)asp.countFailOrNullEvent());
    }

    @Test
    public void processLessThanCountEvents() throws Exception {
        AssertionMessageProcessor asp = new AssertionMessageProcessor();
        asp.setFlowConstruct(this.flowConstruct);
        asp.setExpression("trueExpression");
        asp.setCount(5);
        asp.start();
        for (int i = 0; i < 4; ++i) {
            asp.process((MuleEvent)Mockito.mock(MuleEvent.class));
        }
        Assert.assertFalse((boolean)asp.expressionFailed());
        Assert.assertTrue((boolean)asp.countFailOrNullEvent());
    }

    @Test
    public void processExactCountEvents() throws Exception {
        AssertionMessageProcessor asp = new AssertionMessageProcessor();
        asp.setFlowConstruct(this.flowConstruct);
        asp.setExpression("trueExpression");
        asp.setCount(5);
        asp.start();
        for (int i = 0; i < 5; ++i) {
            asp.process((MuleEvent)Mockito.mock(MuleEvent.class));
        }
        Assert.assertFalse((boolean)asp.expressionFailed());
        Assert.assertFalse((boolean)asp.countFailOrNullEvent());
    }

    @Test
    public void processNullEvent() throws Exception {
        AssertionMessageProcessor asp = new AssertionMessageProcessor();
        asp.setFlowConstruct(this.flowConstruct);
        asp.setExpression("trueExpression");
        asp.setCount(5);
        asp.start();
        asp.process(null);
        Assert.assertFalse((boolean)asp.expressionFailed());
        Assert.assertTrue((boolean)asp.countFailOrNullEvent());
    }
}

