/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.spring;

import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.config.ConfigurationException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.routing.MessageInfoMapping;
import org.mule.api.service.Service;
import org.mule.api.transformer.Transformer;
import org.mule.config.spring.SpringXmlConfigurationBuilder;
import org.mule.routing.ExpressionMessageInfoMapping;
import org.mule.service.ServiceCompositeMessageSource;
import org.mule.tck.AbstractConfigBuilderTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.mule.TestCompressionTransformer;

public class SpringNamespaceConfigBuilderV2TestCase
extends AbstractConfigBuilderTestCase {
    public SpringNamespaceConfigBuilderV2TestCase() {
        super(true);
        this.setDisposeContextPerClass(true);
    }

    public String[] getConfigFiles() {
        return new String[]{"org/mule/test/spring/config2/test-xml-mule2-config.xml", "org/mule/test/spring/config2/test-xml-mule2-config-split.xml", "org/mule/test/spring/config2/test-xml-mule2-config-split-properties.xml"};
    }

    public ConfigurationBuilder getBuilder() throws ConfigurationException {
        return new SpringXmlConfigurationBuilder(this.getConfigFiles());
    }

    @Test
    public void testMessageInfoMappingConfig() throws Exception {
        Service d = muleContext.getRegistry().lookupService("msgInfoMappingTestComponent");
        Assert.assertNotNull((Object)d);
        MessageInfoMapping mapping = d.getMessageInfoMapping();
        Assert.assertTrue((boolean)(mapping instanceof ExpressionMessageInfoMapping));
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("id", "myID123");
        props.put("correlation", "myCorrelationID456");
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)"foo", props, muleContext);
        Assert.assertEquals((Object)"myID123", (Object)mapping.getMessageId((MuleMessage)msg));
        Assert.assertEquals((Object)"myCorrelationID456", (Object)mapping.getCorrelationId((MuleMessage)msg));
    }

    @Test
    public void testPropertyTypesConfig() throws Exception {
        Service c = muleContext.getRegistry().lookupService("testPropertiesComponent");
        Assert.assertNotNull((Object)c);
        Object obj = this.getComponent((FlowConstruct)c);
        Assert.assertNotNull((Object)obj);
        Assert.assertTrue((boolean)(obj instanceof Apple));
        Assert.assertTrue((boolean)((Apple)obj).isBitten());
        Assert.assertTrue((boolean)((Apple)obj).isWashed());
    }

    @Test
    public void testEndpointURIParamsConfig() {
        Service d = muleContext.getRegistry().lookupService("testPropertiesComponent");
        Assert.assertNotNull((Object)d);
        ServiceCompositeMessageSource router = (ServiceCompositeMessageSource)d.getMessageSource();
        Assert.assertNotNull((Object)router);
        List endpoints = router.getEndpoints();
        Assert.assertNotNull((Object)endpoints);
        Assert.assertFalse((boolean)endpoints.isEmpty());
        ImmutableEndpoint inboundEndpoint = (ImmutableEndpoint)endpoints.get(0);
        Assert.assertNotNull((Object)inboundEndpoint);
        List transformers = inboundEndpoint.getTransformers();
        Assert.assertFalse((boolean)transformers.isEmpty());
        Assert.assertNotNull(transformers.get(0));
        List responseTransformers = inboundEndpoint.getResponseTransformers();
        Assert.assertFalse((boolean)responseTransformers.isEmpty());
        Assert.assertNotNull(responseTransformers.get(0));
    }

    public void testTransformerConfig() {
        super.testTransformerConfig();
        Transformer t = muleContext.getRegistry().lookupTransformer("TestCompressionTransformer");
        Assert.assertNotNull((Object)t);
        Assert.assertTrue((boolean)(t instanceof TestCompressionTransformer));
        Assert.assertEquals((Object)"this was set from the manager properties!", (Object)((TestCompressionTransformer)t).getBeanProperty1());
        Assert.assertEquals((long)12L, (long)((TestCompressionTransformer)t).getBeanProperty2());
        Assert.assertEquals((Object)t.getReturnClass(), String.class);
        t = muleContext.getRegistry().lookupTransformer("TestTransformer");
        Assert.assertNotNull((Object)t);
        Assert.assertEquals((Object)t.getReturnClass(), byte[].class);
    }
}

