/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.spring;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.service.Service;
import org.mule.component.PooledJavaComponent;
import org.mule.config.PoolingProfile;
import org.mule.construct.Flow;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

public class PoolingProfileTestCase
extends AbstractServiceAndFlowTestCase {
    private static boolean evicted;

    public PoolingProfileTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "pooling-profile-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "pooling-profile-test-flow.xml"});
    }

    @Test
    public void testDefault() {
        this.doTest("default", 2, 1, 5, 5, 4000L);
    }

    @Test
    public void testFailAll() {
        this.doTest("fail_all", 0, 2, 1, 2, 3L);
    }

    @Test
    public void testGrowOne() {
        this.doTest("grow_one", 2, 1, 2, 3, 4L);
    }

    @Test
    public void testWaitNone() {
        this.doTest("wait_none", 1, 0, 3, 4, 5L);
    }

    @Test
    public void testEvictOne() {
        this.doTest("evict_one", 1, 2, 1, 1, 0L);
        PollingProber prober = new PollingProber(5000L, 50L);
        prober.check(new Probe(){

            public boolean isSatisfied() {
                return evicted;
            }

            public String describeFailure() {
                return "Pooled component was not evicted";
            }
        });
    }

    protected void doTest(String serviceFlow, int exhausted, int initialisation, int active, int idle, long wait) {
        PooledJavaComponent pjc;
        Object o = muleContext.getRegistry().lookupObject(serviceFlow);
        Assert.assertNotNull((String)serviceFlow, (Object)o);
        if (this.variant.equals((Object)AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE)) {
            Assert.assertTrue((boolean)(((Service)o).getComponent() instanceof PooledJavaComponent));
            pjc = (PooledJavaComponent)((Service)o).getComponent();
        } else {
            Assert.assertTrue((boolean)(((Flow)o).getMessageProcessors().get(0) instanceof PooledJavaComponent));
            pjc = (PooledJavaComponent)((Flow)o).getMessageProcessors().get(0);
        }
        PoolingProfile profile = pjc.getPoolingProfile();
        Assert.assertNotNull((Object)profile);
        Assert.assertEquals((String)"exhausted:", (long)exhausted, (long)profile.getExhaustedAction());
        Assert.assertEquals((String)"initialisation:", (long)initialisation, (long)profile.getInitialisationPolicy());
        Assert.assertEquals((String)"active:", (long)active, (long)profile.getMaxActive());
        Assert.assertEquals((String)"idle:", (long)idle, (long)profile.getMaxIdle());
        Assert.assertEquals((String)"wait:", (long)wait, (long)profile.getMaxWait());
    }

    public static class EvictablePooledComponent
    extends FunctionalTestComponent {
        public void dispose() {
            super.dispose();
            evicted = true;
        }
    }
}

