/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.spring;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mule.MessageExchangePattern;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.transaction.TransactionFactory;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageReceiver;
import org.mule.api.transport.MuleMessageFactory;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.testmodels.mule.TestConnector;
import org.mule.tck.testmodels.mule.TestMessageReceiver;
import org.mule.test.spring.MockMuleMessageFactory;
import org.mule.transaction.XaTransactionFactory;
import org.mule.transport.service.TransportServiceDescriptor;

public class ConnectorServiceOverridesTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/spring/service-overrides.xml";
    }

    @Test
    public void testOverrideMessageReceiver() throws Exception {
        TestConnector connector = this.lookupDummyConnector();
        InboundEndpoint endpoint = ConnectorServiceOverridesTestCase.getTestInboundEndpoint((String)"foo");
        endpoint.getTransactionConfig().setAction((byte)1);
        endpoint.getTransactionConfig().setFactory((TransactionFactory)new XaTransactionFactory());
        TransportServiceDescriptor serviceDescriptor = connector.getServiceDescriptor();
        MessageReceiver receiver = serviceDescriptor.createMessageReceiver((Connector)connector, (FlowConstruct)ConnectorServiceOverridesTestCase.getTestService(), endpoint);
        Assert.assertEquals(TestMessageReceiver.class, receiver.getClass());
    }

    private TestConnector lookupDummyConnector() {
        TestConnector connector = (TestConnector)muleContext.getRegistry().lookupConnector("dummyConnector");
        Assert.assertNotNull((Object)connector);
        return connector;
    }

    @Test
    public void testOverrideMuleMessageFactory() throws Exception {
        TestConnector connector = this.lookupDummyConnector();
        TransportServiceDescriptor serviceDescriptor = connector.getServiceDescriptor();
        MuleMessageFactory messageFactory = serviceDescriptor.createMuleMessageFactory();
        Assert.assertEquals(MockMuleMessageFactory.class, messageFactory.getClass());
    }

    @Test
    public void testOverrideInbounExchangePatterns() throws Exception {
        TestConnector connector = this.lookupDummyConnector();
        TransportServiceDescriptor serviceDescriptor = connector.getServiceDescriptor();
        List meps = serviceDescriptor.getInboundExchangePatterns();
        List<MessageExchangePattern> expected = Arrays.asList(MessageExchangePattern.REQUEST_RESPONSE);
        Assert.assertEquals(expected, (Object)meps);
    }

    @Test
    public void testOverrideOutboundExchangePatterns() throws Exception {
        TestConnector connector = this.lookupDummyConnector();
        TransportServiceDescriptor serviceDescriptor = connector.getServiceDescriptor();
        List meps = serviceDescriptor.getOutboundExchangePatterns();
        List<MessageExchangePattern> expected = Arrays.asList(MessageExchangePattern.REQUEST_RESPONSE);
        Assert.assertEquals(expected, (Object)meps);
    }

    @Test
    public void testOverrideDefaultExchangePattern() throws Exception {
        TestConnector connector = this.lookupDummyConnector();
        TransportServiceDescriptor serviceDescriptor = connector.getServiceDescriptor();
        MessageExchangePattern defaultMep = serviceDescriptor.getDefaultExchangePattern();
        Assert.assertEquals((Object)MessageExchangePattern.REQUEST_RESPONSE, (Object)defaultMep);
    }
}

