/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MessagingException;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.service.Service;
import org.mule.api.transport.MessageReceiver;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transport.AbstractConnector;

public class ServiceStateTestCase
extends FunctionalTestCase {
    public ServiceStateTestCase() {
        this.setStartContext(true);
    }

    protected String getConfigFile() {
        return "org/mule/test/components/component-initial-state.xml";
    }

    @Test
    public void testDefaultInitialState() throws Exception {
        Service c = muleContext.getRegistry().lookupService("defaultComponent");
        Assert.assertTrue((boolean)c.isStarted());
        Assert.assertFalse((boolean)c.isPaused());
        Assert.assertFalse((boolean)c.isStopped());
        AbstractConnector connector = (AbstractConnector)muleContext.getRegistry().lookupConnector("connector.test.mule.default");
        Assert.assertNotNull((Object)connector);
        Assert.assertTrue((boolean)connector.isStarted());
        MessageReceiver[] receivers = connector.getReceivers("*default*");
        Assert.assertEquals((long)1L, (long)receivers.length);
        Assert.assertTrue((boolean)receivers[0].isConnected());
    }

    @Test
    public void testInitialStateStopped() throws Exception {
        Service c = muleContext.getRegistry().lookupService("stoppedComponent");
        Assert.assertEquals((Object)"stopped", (Object)c.getInitialState());
        Assert.assertFalse((boolean)c.isStarted());
        Assert.assertTrue((boolean)c.isStopped());
        Assert.assertFalse((boolean)c.isPaused());
        AbstractConnector connector = (AbstractConnector)muleContext.getRegistry().lookupConnector("connector.test.mule.default");
        Assert.assertNotNull((Object)connector);
        Assert.assertTrue((boolean)connector.isStarted());
        MessageReceiver[] receivers = connector.getReceivers("*stopped*");
        Assert.assertEquals((long)0L, (long)receivers.length);
        c.start();
        Assert.assertTrue((boolean)c.isStarted());
        Assert.assertFalse((boolean)c.isStopped());
        Assert.assertFalse((boolean)c.isPaused());
        Assert.assertTrue((boolean)connector.isStarted());
        receivers = connector.getReceivers("*stopped*");
        Assert.assertEquals((long)1L, (long)receivers.length);
        Assert.assertTrue((boolean)receivers[0].isConnected());
    }

    @Test
    public void testStoppingComponentStopsEndpoints() throws Exception {
        Service c = muleContext.getRegistry().lookupService("startedComponent");
        Assert.assertTrue((boolean)c.isStarted());
        Assert.assertFalse((boolean)c.isStopped());
        Assert.assertFalse((boolean)c.isPaused());
        AbstractConnector connector = (AbstractConnector)muleContext.getRegistry().lookupConnector("connector.test.mule.default");
        Assert.assertNotNull((Object)connector);
        Assert.assertTrue((boolean)connector.isStarted());
        MessageReceiver[] receivers = connector.getReceivers("*started*");
        Assert.assertEquals((long)1L, (long)receivers.length);
        Assert.assertTrue((boolean)receivers[0].isConnected());
        c.stop();
        Assert.assertFalse((boolean)c.isStarted());
        Assert.assertFalse((boolean)c.isPaused());
        Assert.assertTrue((boolean)c.isStopped());
        Assert.assertTrue((boolean)connector.isStarted());
        receivers = connector.getReceivers("*started*");
        Assert.assertEquals((long)0L, (long)receivers.length);
    }

    @Test
    public void testSendToStoppedComponent() throws Exception {
        Service c = muleContext.getRegistry().lookupService("stoppedComponent");
        Assert.assertFalse((boolean)c.isStarted());
        Assert.assertFalse((boolean)c.isPaused());
        Assert.assertTrue((boolean)c.isStopped());
        try {
            c.dispatchEvent(ServiceStateTestCase.getTestEvent((Object)"hello", (FlowConstruct)c));
            Assert.fail();
        }
        catch (MessagingException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof LifecycleException));
        }
        try {
            c.sendEvent(ServiceStateTestCase.getTestEvent((Object)"hello", (FlowConstruct)c));
            Assert.fail();
        }
        catch (MessagingException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof LifecycleException));
        }
    }

    @Test
    public void testInitialStatePaused() throws Exception {
        Service c = muleContext.getRegistry().lookupService("pausedComponent");
        Assert.assertFalse((boolean)c.isStarted());
        Assert.assertTrue((boolean)c.isPaused());
        Assert.assertFalse((boolean)c.isStopped());
        AbstractConnector connector = (AbstractConnector)muleContext.getRegistry().lookupConnector("connector.test.mule.default");
        Assert.assertNotNull((Object)connector);
        Assert.assertTrue((boolean)connector.isStarted());
        MessageReceiver[] receivers = connector.getReceivers("*paused*");
        Assert.assertEquals((long)1L, (long)receivers.length);
        Assert.assertTrue((boolean)receivers[0].isConnected());
    }

    @Test
    public void testSendToPausedComponent() throws Exception {
        final Service c = muleContext.getRegistry().lookupService("startedComponent");
        Assert.assertTrue((boolean)c.isStarted());
        Assert.assertFalse((boolean)c.isPaused());
        Assert.assertFalse((boolean)c.isStopped());
        c.pause();
        Assert.assertTrue((boolean)c.isPaused());
        Assert.assertFalse((boolean)c.isStopped());
        Assert.assertFalse((boolean)c.isStarted());
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                try {
                    c.resume();
                }
                catch (MuleException e) {
                    Assert.fail((String)e.getMessage());
                }
            }
        }).start();
        long t0 = System.currentTimeMillis();
        c.sendEvent(ServiceStateTestCase.getTestEvent((Object)"hello"));
        long t1 = System.currentTimeMillis();
        Assert.assertTrue((t1 - t0 > 1000L ? 1 : 0) != 0);
    }
}

