/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.service.Service;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.testmodels.fruit.Orange;

public class ServiceDescriptorServiceTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/components/service-factory-functional-test-service.xml";
    }

    @Test
    public void testGenericObjectFactory() throws Exception {
        Service c = muleContext.getRegistry().lookupService("orange1");
        Object service = this.getComponent((FlowConstruct)c);
        Assert.assertTrue((String)"Service should be an Orange", (boolean)(service instanceof Orange));
        Assert.assertEquals((Object)new Integer(10), (Object)((Orange)service).getSegments());
    }

    @Test
    public void testGenericObjectFactoryWithProperties() throws Exception {
        Service c = muleContext.getRegistry().lookupService("orange2");
        Object service = this.getComponent((FlowConstruct)c);
        Assert.assertTrue((String)"Service should be an Orange", (boolean)(service instanceof Orange));
        Assert.assertEquals((Object)new Integer(8), (Object)((Orange)service).getSegments());
        Assert.assertEquals((Object)"Florida Sunny", (Object)((Orange)service).getBrand());
        service = this.getComponent((FlowConstruct)c);
        Assert.assertTrue((String)"Service should be an Orange", (boolean)(service instanceof Orange));
        Assert.assertEquals((Object)new Integer(8), (Object)((Orange)service).getSegments());
        Assert.assertEquals((Object)"Florida Sunny", (Object)((Orange)service).getBrand());
    }

    @Test
    public void testSingletonObjectFactory() throws Exception {
        Service c = muleContext.getRegistry().lookupService("orange3");
        Object service = this.getComponent((FlowConstruct)c);
        Assert.assertTrue((String)"Service should be an Orange", (boolean)(service instanceof Orange));
        Assert.assertEquals((Object)new Integer(10), (Object)((Orange)service).getSegments());
    }

    @Test
    public void testSpringSingleton() throws Exception {
        Service c = muleContext.getRegistry().lookupService("orange4");
        Object service = this.getComponent((FlowConstruct)c);
        Assert.assertTrue((String)"Service should be an Orange", (boolean)(service instanceof Orange));
        Assert.assertEquals((Object)new Integer(10), (Object)((Orange)service).getSegments());
    }

    @Test
    public void testSpringFactoryBean() throws Exception {
        Service c = muleContext.getRegistry().lookupService("orange5");
        Object service = this.getComponent((FlowConstruct)c);
        Assert.assertNotNull((Object)service);
        Assert.assertTrue((String)("Service should be an Orange but is: " + service.getClass()), (boolean)(service instanceof Orange));
        Assert.assertEquals((Object)new Integer(8), (Object)((Orange)service).getSegments());
        Assert.assertEquals((Object)"Florida Sunny", (Object)((Orange)service).getBrand());
    }

    @Test
    public void testPojoAsFactoryBean() throws Exception {
        Service c = muleContext.getRegistry().lookupService("orange6");
        Object service = this.getComponent((FlowConstruct)c);
        Assert.assertNotNull((Object)service);
        Assert.assertTrue((String)("Service should be an Orange but is: " + service.getClass()), (boolean)(service instanceof Orange));
        Assert.assertEquals((Object)"Florida Sunny", (Object)((Orange)service).getBrand());
    }
}

