/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.transport.MessageReceiver;
import org.mule.construct.AbstractFlowConstruct;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transport.AbstractConnector;

public class PatternFlowStateTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/components/pattern-flows-initial-state.xml";
    }

    @Test
    public void testDefaultInitialstate() throws Exception {
        this.doTestStarted("defaultSimpleService", "in.simple.default");
    }

    @Test
    public void testStartedInitialstate() throws Exception {
        this.doTestStarted("startedSimpleService", "in.simple.started");
    }

    @Test
    public void testInitialStateStopped() throws Exception {
        this.doTestStopped("stoppedSimpleService", "in.simple.stopped");
    }

    @Test
    public void testBridgeDefaultInitialstate() throws Exception {
        this.doTestStarted("defaultBridge", "in.bridge.default");
    }

    @Test
    public void testBridgeStartedInitialstate() throws Exception {
        this.doTestStarted("startedBridge", "in.bridge.started");
    }

    @Test
    public void testBridgeInitialStateStopped() throws Exception {
        this.doTestStopped("stoppedBridge", "in.bridge.stopped");
    }

    @Test
    public void testValidatorDefaultInitialstate() throws Exception {
        this.doTestStarted("defaultValidator", "in.validator.default");
    }

    @Test
    public void testValidatorStartedInitialstate() throws Exception {
        this.doTestStarted("startedValidator", "in.validator.started");
    }

    @Test
    public void testValidatorInitialStateStopped() throws Exception {
        this.doTestStopped("stoppedValidator", "in.validator.stopped");
    }

    protected void doTestStarted(String flowName, String endpointName) throws Exception {
        AbstractFlowConstruct f = (AbstractFlowConstruct)muleContext.getRegistry().lookupFlowConstruct(flowName);
        Assert.assertTrue((boolean)f.isStarted());
        Assert.assertFalse((boolean)f.isStopped());
        this.doListenerTests(endpointName, 1, true);
    }

    public void doTestStopped(String flowName, String endpointName) throws Exception {
        AbstractFlowConstruct f = (AbstractFlowConstruct)muleContext.getRegistry().lookupFlowConstruct(flowName);
        Assert.assertEquals((Object)"stopped", (Object)f.getInitialState());
        Assert.assertFalse((boolean)f.isStarted());
        Assert.assertTrue((boolean)f.isStopped());
        this.doListenerTests(endpointName, 0, true);
        f.start();
        Assert.assertTrue((boolean)f.isStarted());
        Assert.assertFalse((boolean)f.isStopped());
        this.doListenerTests(endpointName, 1, true);
    }

    protected void doListenerTests(String receiverName, int expectedCount, boolean isConnected) {
        AbstractConnector connector = (AbstractConnector)muleContext.getRegistry().lookupConnector("connector.test.mule.default");
        Assert.assertNotNull((Object)connector);
        Assert.assertTrue((boolean)connector.isStarted());
        MessageReceiver[] receivers = connector.getReceivers("*" + receiverName + "*");
        Assert.assertEquals((long)expectedCount, (long)receivers.length);
        for (int i = 0; i < expectedCount; ++i) {
            Assert.assertEquals((Object)isConnected, (Object)receivers[0].isConnected());
        }
    }
}

