/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.transport.MessageReceiver;
import org.mule.construct.AbstractFlowConstruct;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transport.AbstractConnector;

public class FlowStateTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/components/flow-initial-state.xml";
    }

    @Test
    public void testDefaultInitialstate() throws Exception {
        this.doTestStarted("default");
    }

    @Test
    public void testStartedInitialstate() throws Exception {
        this.doTestStarted("started");
    }

    protected void doTestStarted(String flowName) throws Exception {
        AbstractFlowConstruct f = (AbstractFlowConstruct)muleContext.getRegistry().lookupFlowConstruct(flowName + "Flow");
        Assert.assertTrue((boolean)f.isStarted());
        Assert.assertFalse((boolean)f.isStopped());
        this.doListenerTests(flowName, 1, true);
    }

    @Test
    public void testInitialStateStopped() throws Exception {
        AbstractFlowConstruct f = (AbstractFlowConstruct)muleContext.getRegistry().lookupFlowConstruct("stoppedFlow");
        Assert.assertEquals((Object)"stopped", (Object)f.getInitialState());
        Assert.assertFalse((boolean)f.isStarted());
        Assert.assertTrue((boolean)f.isStopped());
        this.doListenerTests("stopped", 0, true);
        f.start();
        Assert.assertTrue((boolean)f.isStarted());
        Assert.assertFalse((boolean)f.isStopped());
        this.doListenerTests("stopped", 1, true);
    }

    protected void doListenerTests(String receiverName, int expectedCount, boolean isConnected) {
        AbstractConnector connector = (AbstractConnector)muleContext.getRegistry().lookupConnector("connector.test.mule.default");
        Assert.assertNotNull((Object)connector);
        Assert.assertTrue((boolean)connector.isStarted());
        MessageReceiver[] receivers = connector.getReceivers("*" + receiverName + "*");
        Assert.assertEquals((long)expectedCount, (long)receivers.length);
        for (int i = 0; i < expectedCount; ++i) {
            Assert.assertEquals((Object)isConnected, (Object)receivers[0].isConnected());
        }
    }
}

