/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.component.JavaComponent;
import org.mule.api.object.ObjectFactory;
import org.mule.construct.Flow;
import org.mule.tck.junit4.FunctionalTestCase;

public class SpringAOPSpringBeanLookupTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/config/spring/spring-aop-springbeanlookup-config.xml";
    }

    protected boolean isStartContext() {
        return false;
    }

    protected boolean isDisposeContextPerClass() {
        return false;
    }

    @Test
    public void beanType() throws Exception {
        ObjectFactory prototype = this.getPrototypeSpringObjectFactory();
        ObjectFactory singleton = this.getSingletonSpringObjectFactory();
        this.assertProxy(prototype.getObjectClass());
        this.assertProxy(singleton.getObjectClass());
    }

    @Test
    public void beanTypeAfterInstantiation() throws Exception {
        ObjectFactory prototype = this.getPrototypeSpringObjectFactory();
        ObjectFactory singleton = this.getSingletonSpringObjectFactory();
        prototype.getInstance(muleContext);
        singleton.getInstance(muleContext);
        this.assertProxy(prototype.getObjectClass());
        this.assertProxy(singleton.getObjectClass());
    }

    @Test
    public void beanTypeContextStarted() throws Exception {
        muleContext.start();
        ObjectFactory prototype = this.getPrototypeSpringObjectFactory();
        ObjectFactory singleton = this.getSingletonSpringObjectFactory();
        this.assertProxy(prototype.getObjectClass());
        this.assertProxy(singleton.getObjectClass());
    }

    @Test
    public void beanTypeContextStartedAfterInstantiation() throws Exception {
        muleContext.start();
        ObjectFactory prototype = this.getPrototypeSpringObjectFactory();
        ObjectFactory singleton = this.getSingletonSpringObjectFactory();
        prototype.getInstance(muleContext);
        singleton.getInstance(muleContext);
        this.assertProxy(prototype.getObjectClass());
        this.assertProxy(singleton.getObjectClass());
    }

    private void assertProxy(Class<?> clazz) {
        Assert.assertTrue((boolean)clazz.getName().contains("$Proxy"));
    }

    private ObjectFactory getPrototypeSpringObjectFactory() throws Exception {
        return ((JavaComponent)((Flow)this.getFlowConstruct("flow")).getMessageProcessors().get(0)).getObjectFactory();
    }

    private ObjectFactory getSingletonSpringObjectFactory() throws Exception {
        return ((JavaComponent)((Flow)this.getFlowConstruct("flow")).getMessageProcessors().get(1)).getObjectFactory();
    }
}

