/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import java.util.List;
import org.mule.impl.AbstractExceptionListener;
import org.mule.impl.model.resolvers.LegacyEntryPointResolverSet;
import org.mule.routing.ForwardingCatchAllStrategy;
import org.mule.routing.filters.xml.JXPathFilter;
import org.mule.routing.outbound.OutboundPassThroughRouter;
import org.mule.tck.FunctionalTestCase;
import org.mule.tck.testmodels.fruit.FruitCleaner;
import org.mule.tck.testmodels.mule.TestCompressionTransformer;
import org.mule.tck.testmodels.mule.TestConnector;
import org.mule.tck.testmodels.mule.TestEntryPointResolverSet;
import org.mule.tck.testmodels.mule.TestExceptionStrategy;
import org.mule.tck.testmodels.mule.TestInboundTransformer;
import org.mule.tck.testmodels.mule.TestResponseAggregator;
import org.mule.transformers.TransformerUtils;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.manager.ObjectNotFoundException;
import org.mule.umo.model.UMOModel;
import org.mule.umo.routing.UMOInboundRouterCollection;
import org.mule.umo.routing.UMONestedRouter;
import org.mule.umo.routing.UMONestedRouterCollection;
import org.mule.umo.routing.UMOOutboundRouter;
import org.mule.umo.routing.UMOOutboundRouterCollection;
import org.mule.umo.routing.UMOResponseRouter;
import org.mule.umo.routing.UMOResponseRouterCollection;
import org.mule.umo.transformer.UMOTransformer;

public abstract class AbstractScriptConfigBuilderTestCase
extends FunctionalTestCase {
    private boolean legacy;

    protected AbstractScriptConfigBuilderTestCase() {
        this(false);
    }

    protected AbstractScriptConfigBuilderTestCase(boolean legacy) {
        this.legacy = legacy;
        this.setDisposeManagerPerSuite(true);
    }

    public void testManagerConfig() throws Exception {
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)"true", (Object)managementContext.getRegistry().lookupObject("doCompression"));
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)managementContext.getTransactionManager());
    }

    public void testConnectorConfig() throws Exception {
        TestConnector c = (TestConnector)managementContext.getRegistry().lookupConnector("dummyConnector");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)c);
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)c.getExceptionListener());
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(c.getExceptionListener() instanceof TestExceptionStrategy));
    }

    public void testGlobalEndpointConfig() throws UMOException {
        UMOImmutableEndpoint endpoint = managementContext.getRegistry().lookupEndpointFactory().getInboundEndpoint("fruitBowlEndpoint");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)endpoint.getEndpointURI().getAddress(), (String)"fruitBowlPublishQ");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)endpoint.getFilter());
        JXPathFilter filter = (JXPathFilter)endpoint.getFilter();
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"name", (String)filter.getPattern());
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"bar", (String)filter.getExpectedValue());
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)"http://foo.com", filter.getNamespaces().get("foo"));
    }

    public void testEndpointConfig() throws UMOException {
        UMOImmutableEndpoint endpoint = managementContext.getRegistry().lookupEndpointFactory().getInboundEndpoint("waterMelonEndpoint");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"test.queue", (String)endpoint.getEndpointURI().getAddress());
        UMOComponent component = managementContext.getRegistry().lookupComponent("orangeComponent");
        UMOImmutableEndpoint ep = component.getInboundRouter().getEndpoint("Orange");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)ep);
        List responseTransformers = ep.getResponseTransformers();
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)responseTransformers);
        AbstractScriptConfigBuilderTestCase.assertFalse((boolean)responseTransformers.isEmpty());
        Object responseTransformer = responseTransformers.get(0);
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(responseTransformer instanceof TestCompressionTransformer));
    }

    public void testExceptionStrategy() {
        UMOComponent component = managementContext.getRegistry().lookupComponent("orangeComponent");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)managementContext.getRegistry().lookupModel("main").getExceptionListener());
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)component.getExceptionListener());
        AbstractScriptConfigBuilderTestCase.assertTrue((((AbstractExceptionListener)component.getExceptionListener()).getEndpoints().size() > 0 ? 1 : 0) != 0);
        UMOEndpoint ep = (UMOEndpoint)((AbstractExceptionListener)component.getExceptionListener()).getEndpoints().get(0);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"test://orange.exceptions", (String)ep.getEndpointURI().toString());
    }

    public void testTransformerConfig() {
        UMOTransformer t = managementContext.getRegistry().lookupTransformer("TestCompressionTransformer");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)t);
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(t instanceof TestCompressionTransformer));
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)t.getReturnClass(), (Object)String.class);
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)((TestCompressionTransformer)t).getContainerProperty());
    }

    public void testModelConfig() throws Exception {
        UMOModel model = managementContext.getRegistry().lookupModel("main");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)model);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"main", (String)model.getName());
        if (this.legacy) {
            AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(model.getEntryPointResolverSet() instanceof LegacyEntryPointResolverSet));
        } else {
            AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(model.getEntryPointResolverSet() instanceof TestEntryPointResolverSet));
        }
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(model.getExceptionListener() instanceof TestExceptionStrategy));
        AbstractScriptConfigBuilderTestCase.assertTrue((((AbstractExceptionListener)model.getExceptionListener()).getEndpoints().size() > 0 ? 1 : 0) != 0);
        UMOEndpoint ep = (UMOEndpoint)((AbstractExceptionListener)model.getExceptionListener()).getEndpoints().get(0);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"test://component.exceptions", (String)ep.getEndpointURI().toString());
    }

    public void testOutboundRouterConfig() {
        UMOComponent component = managementContext.getRegistry().lookupComponent("orangeComponent");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)component.getOutboundRouter());
        UMOOutboundRouterCollection router = component.getOutboundRouter();
        AbstractScriptConfigBuilderTestCase.assertNull((Object)router.getCatchAllStrategy());
        AbstractScriptConfigBuilderTestCase.assertEquals((int)1, (int)router.getRouters().size());
        UMOOutboundRouter route1 = (UMOOutboundRouter)router.getRouters().get(0);
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(route1 instanceof OutboundPassThroughRouter));
        AbstractScriptConfigBuilderTestCase.assertEquals((int)1, (int)route1.getEndpoints().size());
    }

    public void testNestedRouterConfig() throws ObjectNotFoundException {
        UMOComponent component = managementContext.getRegistry().lookupComponent("orangeComponent");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)component.getNestedRouter());
        UMONestedRouterCollection router = component.getNestedRouter();
        AbstractScriptConfigBuilderTestCase.assertEquals((int)2, (int)router.getRouters().size());
        UMONestedRouter route1 = (UMONestedRouter)router.getRouters().get(0);
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)FruitCleaner.class, (Object)route1.getInterface());
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"wash", (String)route1.getMethod());
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)route1.getOutboundRouter());
        AbstractScriptConfigBuilderTestCase.assertEquals((int)1, (int)route1.getOutboundRouter().getEndpoints().size());
        UMONestedRouter route2 = (UMONestedRouter)router.getRouters().get(1);
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)FruitCleaner.class, (Object)route2.getInterface());
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"polish", (String)route2.getMethod());
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)route2.getOutboundRouter());
        AbstractScriptConfigBuilderTestCase.assertEquals((int)1, (int)route2.getOutboundRouter().getEndpoints().size());
    }

    public void testDescriptorEndpoints() {
        UMOComponent component = managementContext.getRegistry().lookupComponent("orangeComponent");
        AbstractScriptConfigBuilderTestCase.assertEquals((int)1, (int)component.getOutboundRouter().getRouters().size());
        UMOOutboundRouter router = (UMOOutboundRouter)component.getOutboundRouter().getRouters().get(0);
        AbstractScriptConfigBuilderTestCase.assertEquals((int)1, (int)router.getEndpoints().size());
        UMOImmutableEndpoint endpoint = (UMOImmutableEndpoint)router.getEndpoints().get(0);
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"appleInEndpoint", (String)endpoint.getName());
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)endpoint.getTransformers());
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(TransformerUtils.firstOrNull((List)endpoint.getTransformers()) instanceof TestCompressionTransformer));
        try {
            endpoint = managementContext.getRegistry().lookupEndpointFactory().getInboundEndpoint("appleInEndpoint");
        }
        catch (UMOException e) {
            e.printStackTrace();
            AbstractScriptConfigBuilderTestCase.fail((String)e.getMessage());
        }
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)TransformerUtils.isDefined((List)endpoint.getTransformers()));
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(endpoint.getTransformers().get(0) instanceof TestInboundTransformer));
        AbstractScriptConfigBuilderTestCase.assertEquals((int)2, (int)component.getInboundRouter().getEndpoints().size());
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)component.getInboundRouter().getCatchAllStrategy());
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(component.getInboundRouter().getCatchAllStrategy() instanceof ForwardingCatchAllStrategy));
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)component.getInboundRouter().getCatchAllStrategy().getEndpoint());
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"test://catch.all", (String)component.getInboundRouter().getCatchAllStrategy().getEndpoint().getEndpointURI().toString());
        endpoint = component.getInboundRouter().getEndpoint("orangeEndpoint");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"orangeEndpoint", (String)endpoint.getName());
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"orangeQ", (String)endpoint.getEndpointURI().getAddress());
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)endpoint.getTransformers());
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(TransformerUtils.firstOrNull((List)endpoint.getTransformers()) instanceof TestCompressionTransformer));
        try {
            endpoint = managementContext.getRegistry().lookupEndpointFactory().getInboundEndpoint("orangeEndpoint");
        }
        catch (UMOException e) {
            e.printStackTrace();
            AbstractScriptConfigBuilderTestCase.fail((String)e.getMessage());
        }
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)TransformerUtils.isDefined((List)endpoint.getTransformers()));
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(endpoint.getTransformers().get(0) instanceof TestInboundTransformer));
    }

    public void testInboundRouterConfig() {
        UMOComponent component = managementContext.getRegistry().lookupComponent("orangeComponent");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)component.getInboundRouter());
        UMOInboundRouterCollection messageRouter = component.getInboundRouter();
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)messageRouter.getCatchAllStrategy());
        AbstractScriptConfigBuilderTestCase.assertEquals((int)0, (int)messageRouter.getRouters().size());
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(messageRouter.getCatchAllStrategy() instanceof ForwardingCatchAllStrategy));
        AbstractScriptConfigBuilderTestCase.assertEquals((int)2, (int)messageRouter.getEndpoints().size());
    }

    public void testResponseRouterConfig() {
        UMOComponent component = managementContext.getRegistry().lookupComponent("orangeComponent");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)component.getResponseRouter());
        UMOResponseRouterCollection messageRouter = component.getResponseRouter();
        AbstractScriptConfigBuilderTestCase.assertNull((Object)messageRouter.getCatchAllStrategy());
        AbstractScriptConfigBuilderTestCase.assertEquals((int)10001, (int)messageRouter.getTimeout());
        AbstractScriptConfigBuilderTestCase.assertEquals((int)1, (int)messageRouter.getRouters().size());
        UMOResponseRouter router = (UMOResponseRouter)messageRouter.getRouters().get(0);
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(router instanceof TestResponseAggregator));
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)messageRouter.getEndpoints());
        AbstractScriptConfigBuilderTestCase.assertEquals((int)2, (int)messageRouter.getEndpoints().size());
        UMOEndpoint ep = (UMOEndpoint)messageRouter.getEndpoints().get(0);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"response1", (String)ep.getEndpointURI().getAddress());
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"response", (String)ep.getType());
        ep = (UMOEndpoint)messageRouter.getEndpoints().get(1);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"AppleResponseQueue", (String)ep.getEndpointURI().getAddress());
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"response", (String)ep.getType());
    }
}

