/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.internal.dsl.declaration;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.app.declaration.ArtifactDeclaration;
import org.mule.runtime.api.app.declaration.ComponentElementDeclaration;
import org.mule.runtime.api.app.declaration.ConnectionElementDeclaration;
import org.mule.runtime.api.app.declaration.GlobalElementDeclaration;
import org.mule.runtime.api.app.declaration.ParameterGroupElementDeclaration;
import org.mule.runtime.api.app.declaration.ParameterValue;
import org.mule.runtime.api.app.declaration.RouteElementDeclaration;
import org.mule.runtime.api.app.declaration.fluent.ArtifactDeclarer;
import org.mule.runtime.api.app.declaration.fluent.ComponentElementDeclarer;
import org.mule.runtime.api.app.declaration.fluent.ConfigurationElementDeclarer;
import org.mule.runtime.api.app.declaration.fluent.ConnectionElementDeclarer;
import org.mule.runtime.api.app.declaration.fluent.ConstructElementDeclarer;
import org.mule.runtime.api.app.declaration.fluent.ElementDeclarer;
import org.mule.runtime.api.app.declaration.fluent.HasNestedComponentDeclarer;
import org.mule.runtime.api.app.declaration.fluent.OperationElementDeclarer;
import org.mule.runtime.api.app.declaration.fluent.ParameterGroupElementDeclarer;
import org.mule.runtime.api.app.declaration.fluent.ParameterListValue;
import org.mule.runtime.api.app.declaration.fluent.ParameterObjectValue;
import org.mule.runtime.api.app.declaration.fluent.ParameterSimpleValue;
import org.mule.runtime.api.app.declaration.fluent.ParameterizedBuilder;
import org.mule.runtime.api.app.declaration.fluent.ParameterizedElementDeclarer;
import org.mule.runtime.api.app.declaration.fluent.RouteElementDeclarer;
import org.mule.runtime.api.app.declaration.fluent.TopLevelParameterDeclarer;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ComposableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.construct.HasConstructModels;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.config.spring.api.XmlConfigurationDocumentLoader;
import org.mule.runtime.config.spring.api.dsl.processor.ConfigLine;
import org.mule.runtime.config.spring.api.dsl.processor.SimpleConfigAttribute;
import org.mule.runtime.config.spring.api.dsl.processor.xml.XmlApplicationParser;
import org.mule.runtime.config.spring.api.dsl.processor.xml.XmlApplicationServiceRegistry;
import org.mule.runtime.config.spring.internal.dsl.model.XmlArtifactDeclarationLoader;
import org.mule.runtime.core.api.registry.ServiceRegistry;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;
import org.mule.runtime.deployment.model.internal.application.MuleApplicationClassLoader;
import org.mule.runtime.extension.api.declaration.type.annotation.ExtensibleTypeAnnotation;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.w3c.dom.Document;

public class DefaultXmlArtifactDeclarationLoader
implements XmlArtifactDeclarationLoader {
    public static final String TRANSFORM_IDENTIFIER = "transform";
    public static final String TRANSFORM_SCRIPT = "script";
    public static final String TRANSFORM_RESOURCE = "resource";
    public static final String TRANSFORM_VARIABLE_NAME = "variableName";
    private final DslResolvingContext context;
    private final Map<ExtensionModel, DslSyntaxResolver> resolvers;
    private final Map<String, ExtensionModel> extensionsByNamespace = new HashMap<String, ExtensionModel>();

    public DefaultXmlArtifactDeclarationLoader(DslResolvingContext context) {
        this.context = context;
        this.resolvers = context.getExtensions().stream().collect(Collectors.toMap(e -> e, e -> DslSyntaxResolver.getDefault((ExtensionModel)e, (DslResolvingContext)context)));
    }

    @Override
    public ArtifactDeclaration load(InputStream configResource) {
        return this.load("app.xml", configResource);
    }

    @Override
    public ArtifactDeclaration load(String name, InputStream configResource) {
        this.context.getExtensions().forEach(e -> this.extensionsByNamespace.put(e.getXmlDslModel().getPrefix(), (ExtensionModel)e));
        ConfigLine configLine = this.loadArtifactConfig(name, configResource);
        return this.declareArtifact(configLine);
    }

    private ConfigLine loadArtifactConfig(String name, InputStream resource) {
        Preconditions.checkArgument((resource != null ? 1 : 0) != 0, (Object)"The given application was not found as resource");
        Document document = XmlConfigurationDocumentLoader.noValidationDocumentLoader().loadDocument(this.context.getExtensions(), name, resource);
        return new XmlApplicationParser((ServiceRegistry)new XmlApplicationServiceRegistry((ServiceRegistry)new SpiServiceRegistry(), this.context), MuleApplicationClassLoader.resolveContextArtifactPluginClassLoaders()).parse(document.getDocumentElement()).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not load load a Configuration from the given resource")));
    }

    private ArtifactDeclaration declareArtifact(ConfigLine configLine) {
        ArtifactDeclarer artifactDeclarer = ElementDeclarer.newArtifact();
        configLine.getConfigAttributes().values().forEach(a -> {
            ArtifactDeclarer cfr_ignored_0 = (ArtifactDeclarer)artifactDeclarer.withCustomParameter(a.getName(), a.getValue());
        });
        configLine.getChildren().forEach(line -> this.declareElement((ConfigLine)line, artifactDeclarer));
        return (ArtifactDeclaration)artifactDeclarer.getDeclaration();
    }

    private void declareElement(final ConfigLine configLine, final ArtifactDeclarer artifactDeclarer) {
        final ExtensionModel ownerExtension = this.getExtensionModel(configLine);
        final ElementDeclarer extensionElementsDeclarer = ElementDeclarer.forExtension((String)ownerExtension.getName());
        final DslSyntaxResolver dsl = this.resolvers.get(ownerExtension);
        final Reference alreadyDeclared = new Reference((Object)false);
        new ExtensionWalker(){

            protected void onConstruct(HasConstructModels owner, ConstructModel model) {
                DefaultXmlArtifactDeclarationLoader.this.declareComponentModel(dsl, configLine, (ComponentModel)model, arg_0 -> ((ElementDeclarer)extensionElementsDeclarer).newConstruct(arg_0)).ifPresent(declarer -> {
                    DefaultXmlArtifactDeclarationLoader.this.getDeclaredName(configLine).ifPresent(arg_0 -> ((ConstructElementDeclarer)((ConstructElementDeclarer)declarer)).withRefName(arg_0));
                    artifactDeclarer.withGlobalElement((GlobalElementDeclaration)declarer.getDeclaration());
                    alreadyDeclared.set((Object)true);
                    this.stop();
                });
            }

            protected void onConfiguration(ConfigurationModel model) {
                DslElementSyntax elementDsl = dsl.resolve((NamedObject)model);
                if (elementDsl.getElementName().equals(configLine.getIdentifier())) {
                    ConfigurationElementDeclarer configurationDeclarer = extensionElementsDeclarer.newConfiguration(model.getName());
                    DefaultXmlArtifactDeclarationLoader.this.getDeclaredName(configLine).ifPresent(arg_0 -> ((ConfigurationElementDeclarer)configurationDeclarer).withRefName(arg_0));
                    Map<String, SimpleConfigAttribute> attributes = configLine.getConfigAttributes().values().stream().filter(a -> !a.getName().equals("name")).collect(Collectors.toMap(SimpleConfigAttribute::getName, a -> a));
                    List configComplexParameters = configLine.getChildren().stream().filter(config -> this.declareAsConnectionProvider(ownerExtension, model, configurationDeclarer, (ConfigLine)config)).collect(Collectors.toList());
                    DefaultXmlArtifactDeclarationLoader.this.declareParameterizedComponent((ParameterizedModel)model, elementDsl, (ParameterizedElementDeclarer)configurationDeclarer, attributes, configComplexParameters);
                    artifactDeclarer.withGlobalElement((GlobalElementDeclaration)configurationDeclarer.getDeclaration());
                    alreadyDeclared.set((Object)true);
                    this.stop();
                }
            }

            private boolean declareAsConnectionProvider(ExtensionModel ownerExtension2, ConfigurationModel model, ConfigurationElementDeclarer configurationDeclarer, ConfigLine config) {
                Optional<ConnectionProviderModel> connectionProvider = model.getConnectionProviders().stream().filter(cp -> dsl.resolve((NamedObject)cp).getElementName().equals(config.getIdentifier())).findFirst();
                if (!connectionProvider.isPresent()) {
                    connectionProvider = ownerExtension2.getConnectionProviders().stream().filter(cp -> dsl.resolve((NamedObject)cp).getElementName().equals(config.getIdentifier())).findFirst();
                }
                if (!connectionProvider.isPresent()) {
                    return true;
                }
                ConnectionProviderModel providerModel = connectionProvider.get();
                ConnectionElementDeclarer connectionDeclarer = extensionElementsDeclarer.newConnection(providerModel.getName());
                DefaultXmlArtifactDeclarationLoader.this.declareParameterizedComponent((ParameterizedModel)providerModel, dsl.resolve((NamedObject)providerModel), (ParameterizedElementDeclarer)connectionDeclarer, config.getConfigAttributes(), config.getChildren());
                configurationDeclarer.withConnection((ConnectionElementDeclaration)connectionDeclarer.getDeclaration());
                return false;
            }
        }.walk(ownerExtension);
        if (!((Boolean)alreadyDeclared.get()).booleanValue()) {
            ownerExtension.getTypes().stream().filter(type -> dsl.resolve((MetadataType)type).map(typeDsl -> typeDsl.getElementName().equals(configLine.getIdentifier())).orElse(false)).findFirst().ifPresent(type -> {
                TopLevelParameterDeclarer topLevelParameter = extensionElementsDeclarer.newGlobalParameter(configLine.getIdentifier());
                this.getDeclaredName(configLine).ifPresent(arg_0 -> ((TopLevelParameterDeclarer)topLevelParameter).withRefName(arg_0));
                type.accept(this.getParameterDeclarerVisitor(configLine, (DslElementSyntax)dsl.resolve((MetadataType)type).get(), value -> topLevelParameter.withValue((ParameterObjectValue)value)));
                artifactDeclarer.withGlobalElement((GlobalElementDeclaration)topLevelParameter.getDeclaration());
            });
        }
    }

    private Optional<String> getDeclaredName(ConfigLine configLine) {
        return Optional.ofNullable(configLine.getConfigAttributes().get("name")).map(SimpleConfigAttribute::getValue);
    }

    private ExtensionModel getExtensionModel(ConfigLine line) {
        String namespace = this.getNamespace(line);
        ExtensionModel extensionModel = this.extensionsByNamespace.get(namespace);
        if (extensionModel == null) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Missing Extension model in the context for namespace [" + namespace + "]")));
        }
        return extensionModel;
    }

    private ExtensionWalker getComponentDeclaringWalker(final Consumer<ComponentElementDeclaration> declarationConsumer, final ConfigLine line, final ElementDeclarer extensionElementsDeclarer, final DslSyntaxResolver dsl) {
        return new ExtensionWalker(){

            protected void onOperation(HasOperationModels owner, OperationModel model) {
                if (!model.getName().equals(DefaultXmlArtifactDeclarationLoader.TRANSFORM_IDENTIFIER)) {
                    DefaultXmlArtifactDeclarationLoader.this.declareComponentModel(dsl, line, (ComponentModel)model, arg_0 -> ((ElementDeclarer)extensionElementsDeclarer).newOperation(arg_0)).ifPresent(declarer -> {
                        declarationConsumer.accept((ComponentElementDeclaration)declarer.getDeclaration());
                        this.stop();
                    });
                } else {
                    this.declareTransform((ComponentModel)model);
                }
            }

            protected void onSource(HasSourceModels owner, SourceModel model) {
                DefaultXmlArtifactDeclarationLoader.this.declareComponentModel(dsl, line, (ComponentModel)model, arg_0 -> ((ElementDeclarer)extensionElementsDeclarer).newSource(arg_0)).ifPresent(declarer -> {
                    DslElementSyntax elementDsl = dsl.resolve((NamedObject)model);
                    model.getSuccessCallback().ifPresent(cb -> DefaultXmlArtifactDeclarationLoader.this.declareParameterizedComponent((ParameterizedModel)cb, elementDsl, (ParameterizedElementDeclarer)declarer, line.getConfigAttributes(), line.getChildren()));
                    model.getErrorCallback().ifPresent(cb -> DefaultXmlArtifactDeclarationLoader.this.declareParameterizedComponent((ParameterizedModel)cb, elementDsl, (ParameterizedElementDeclarer)declarer, line.getConfigAttributes(), line.getChildren()));
                    declarationConsumer.accept((ComponentElementDeclaration)declarer.getDeclaration());
                    this.stop();
                });
            }

            protected void onConstruct(HasConstructModels owner, ConstructModel model) {
                DefaultXmlArtifactDeclarationLoader.this.declareComponentModel(dsl, line, (ComponentModel)model, arg_0 -> ((ElementDeclarer)extensionElementsDeclarer).newConstruct(arg_0)).ifPresent(declarer -> {
                    declarationConsumer.accept((ComponentElementDeclaration)declarer.getDeclaration());
                    this.stop();
                });
            }

            private void declareTransform(ComponentModel model) {
                DslElementSyntax elementDsl = dsl.resolve((NamedObject)model);
                if (model.getName().equals(DefaultXmlArtifactDeclarationLoader.TRANSFORM_IDENTIFIER) && elementDsl.getElementName().equals(line.getIdentifier())) {
                    OperationElementDeclarer transform = extensionElementsDeclarer.newOperation(DefaultXmlArtifactDeclarationLoader.TRANSFORM_IDENTIFIER);
                    line.getChildren().stream().filter(c -> c.getIdentifier().equals("message")).findFirst().ifPresent(arg_0 -> this.lambda$declareTransform$10((ComponentElementDeclarer)transform, arg_0));
                    line.getChildren().stream().filter(c -> c.getIdentifier().equals("variables")).findFirst().ifPresent(arg_0 -> this.lambda$declareTransform$13((ComponentElementDeclarer)transform, arg_0));
                    line.getConfigAttributes().values().forEach(arg_0 -> 2.lambda$declareTransform$14((ComponentElementDeclarer)transform, arg_0));
                    declarationConsumer.accept((ComponentElementDeclaration)transform.getDeclaration());
                    this.stop();
                }
            }

            private static /* synthetic */ void lambda$declareTransform$14(ComponentElementDeclarer transform, SimpleConfigAttribute a) {
                transform.withCustomParameter(a.getName(), a.getValue());
            }

            private /* synthetic */ void lambda$declareTransform$13(ComponentElementDeclarer transform, ConfigLine variablesConfig) {
                ParameterGroupElementDeclarer variablesGroup = ElementDeclarer.newParameterGroup((String)"Set Variables");
                ParameterListValue.Builder variables = ElementDeclarer.newListValue();
                variablesConfig.getChildren().forEach(variableConfig -> {
                    ParameterObjectValue.Builder variable = ElementDeclarer.newObjectValue();
                    variable.withParameter(DefaultXmlArtifactDeclarationLoader.TRANSFORM_VARIABLE_NAME, variableConfig.getConfigAttributes().get(DefaultXmlArtifactDeclarationLoader.TRANSFORM_VARIABLE_NAME).getValue());
                    DefaultXmlArtifactDeclarationLoader.this.populateTransformScriptParameter(variableConfig, variable);
                    variables.withValue((ParameterValue)variable.build());
                });
                transform.withParameterGroup((ParameterGroupElementDeclaration)variablesGroup.withParameter("setVariables", (ParameterValue)variables.build()).getDeclaration());
            }

            private /* synthetic */ void lambda$declareTransform$10(ComponentElementDeclarer transform, ConfigLine messageConfig) {
                ParameterGroupElementDeclarer messageGroup = ElementDeclarer.newParameterGroup((String)"Message");
                messageConfig.getChildren().stream().filter(c -> c.getIdentifier().equals("set-payload")).findFirst().ifPresent(payloadConfig -> {
                    ParameterObjectValue.Builder payload = ElementDeclarer.newObjectValue();
                    DefaultXmlArtifactDeclarationLoader.this.populateTransformScriptParameter(payloadConfig, payload);
                    messageGroup.withParameter("setPayload", (ParameterValue)payload.build());
                });
                messageConfig.getChildren().stream().filter(c -> c.getIdentifier().equals("set-attributes")).findFirst().ifPresent(attributesConfig -> {
                    ParameterObjectValue.Builder attributes = ElementDeclarer.newObjectValue();
                    DefaultXmlArtifactDeclarationLoader.this.populateTransformScriptParameter(attributesConfig, attributes);
                    messageGroup.withParameter("setAttributes", (ParameterValue)attributes.build());
                });
                transform.withParameterGroup((ParameterGroupElementDeclaration)messageGroup.getDeclaration());
            }
        };
    }

    private Optional<ComponentElementDeclarer> declareComponentModel(DslSyntaxResolver dsl, ConfigLine line, ComponentModel model, Function<String, ComponentElementDeclarer> declarerBuilder) {
        DslElementSyntax elementDsl = dsl.resolve((NamedObject)model);
        if (elementDsl.getElementName().equals(line.getIdentifier())) {
            ComponentElementDeclarer declarer = declarerBuilder.apply(model.getName());
            if (line.getConfigAttributes().get("config-ref") != null) {
                declarer.withConfig(line.getConfigAttributes().get("config-ref").getValue());
            }
            this.declareParameterizedComponent((ParameterizedModel)model, elementDsl, (ParameterizedElementDeclarer)declarer, line.getConfigAttributes(), line.getChildren());
            if (model instanceof ComposableModel) {
                this.declareComposableModel((ComposableModel)model, elementDsl, dsl, line, (HasNestedComponentDeclarer)declarer);
            }
            return Optional.of(declarer);
        }
        return Optional.empty();
    }

    private void populateTransformScriptParameter(ConfigLine config, ParameterObjectValue.Builder builder) {
        if (config.getConfigAttributes().containsKey(TRANSFORM_RESOURCE)) {
            builder.withParameter(TRANSFORM_RESOURCE, config.getConfigAttributes().get(TRANSFORM_RESOURCE).getValue());
        }
        if (!StringUtils.isBlank((CharSequence)config.getTextContent())) {
            builder.withParameter(TRANSFORM_SCRIPT, config.getTextContent());
        }
        config.getConfigAttributes().entrySet().stream().filter(e -> !((String)e.getKey()).equals(TRANSFORM_RESOURCE)).map(Map.Entry::getValue).forEach(a -> builder.withParameter(a.getName(), a.getValue()));
    }

    private boolean isCData(ConfigLine config) {
        return config.getCustomAttributes().get("IS_CDATA") != null;
    }

    private void declareComposableModel(ComposableModel model, DslElementSyntax elementDsl, DslSyntaxResolver dsl, ConfigLine containerConfig, HasNestedComponentDeclarer declarer) {
        containerConfig.getChildren().forEach(child -> {
            ExtensionModel extensionModel = this.getExtensionModel((ConfigLine)child);
            ElementDeclarer extensionElementsDeclarer = ElementDeclarer.forExtension((String)extensionModel.getName());
            Reference componentFound = new Reference((Object)false);
            this.getComponentDeclaringWalker(declaration -> {
                declarer.withComponent(declaration);
                componentFound.set((Object)true);
            }, (ConfigLine)child, extensionElementsDeclarer, dsl).walk(extensionModel);
            if (!((Boolean)componentFound.get()).booleanValue()) {
                this.declareRoute(model, elementDsl, dsl, (ConfigLine)child, extensionElementsDeclarer).ifPresent(arg_0 -> ((HasNestedComponentDeclarer)declarer).withComponent(arg_0));
            }
        });
    }

    private Optional<RouteElementDeclaration> declareRoute(ComposableModel model, DslElementSyntax elementDsl, DslSyntaxResolver dsl, ConfigLine child, ElementDeclarer extensionElementsDeclarer) {
        return model.getNestedComponents().stream().filter(nestedModel -> elementDsl.getContainedElement(nestedModel.getName()).map(nestedDsl -> child.getIdentifier().equals(nestedDsl.getElementName())).orElse(false)).filter(nestedModel -> nestedModel instanceof NestedRouteModel).findFirst().map(nestedModel -> {
            RouteElementDeclarer routeDeclarer = extensionElementsDeclarer.newRoute(nestedModel.getName());
            DslElementSyntax routeDsl = (DslElementSyntax)elementDsl.getContainedElement(nestedModel.getName()).get();
            this.declareParameterizedComponent((ParameterizedModel)nestedModel, routeDsl, (ParameterizedElementDeclarer)routeDeclarer, child.getConfigAttributes(), child.getChildren());
            this.declareComposableModel((ComposableModel)nestedModel, elementDsl, dsl, child, (HasNestedComponentDeclarer)routeDeclarer);
            return (RouteElementDeclaration)routeDeclarer.getDeclaration();
        });
    }

    private void declareParameterizedComponent(ParameterizedModel model, DslElementSyntax elementDsl, ParameterizedElementDeclarer declarer, Map<String, SimpleConfigAttribute> configAttributes, List<ConfigLine> children) {
        this.copyExplicitAttributes(model, configAttributes, declarer);
        this.declareChildParameters(model, elementDsl, children, declarer);
    }

    private void declareChildParameters(ParameterizedModel model, DslElementSyntax modelDsl, List<ConfigLine> children, ParameterizedElementDeclarer declarer) {
        model.getParameterGroupModels().forEach(group -> {
            if (group.isShowInDsl()) {
                modelDsl.getChild(group.getName()).ifPresent(groupDsl -> children.stream().filter(c -> c.getIdentifier().equals(groupDsl.getElementName())).findFirst().ifPresent(groupConfig -> this.declareInlineGroup((ParameterGroupModel)group, (DslElementSyntax)groupDsl, (ConfigLine)groupConfig, declarer)));
            } else {
                ParameterGroupElementDeclarer groupDeclarer = ElementDeclarer.newParameterGroup((String)group.getName());
                group.getParameterModels().forEach(param -> modelDsl.getChild(param.getName()).ifPresent(paramDsl -> {
                    if (ExtensionModelUtils.isInfrastructure((ParameterModel)param)) {
                        this.handleInfrastructure((ParameterModel)param, children, declarer);
                    } else {
                        children.stream().filter(c -> c.getIdentifier().equals(paramDsl.getElementName())).findFirst().ifPresent(paramConfig -> param.getType().accept(this.getParameterDeclarerVisitor((ConfigLine)paramConfig, (DslElementSyntax)paramDsl, value -> groupDeclarer.withParameter(param.getName(), value))));
                    }
                }));
                if (!((ParameterGroupElementDeclaration)groupDeclarer.getDeclaration()).getParameters().isEmpty()) {
                    declarer.withParameterGroup((ParameterGroupElementDeclaration)groupDeclarer.getDeclaration());
                }
            }
        });
    }

    private void declareInlineGroup(ParameterGroupModel model, DslElementSyntax dsl, ConfigLine config, ParameterizedElementDeclarer groupContainer) {
        ParameterGroupElementDeclarer groupDeclarer = ElementDeclarer.newParameterGroup((String)model.getName());
        this.copyExplicitAttributes(config.getConfigAttributes(), (ParameterizedBuilder<String, ParameterValue, ?>)groupDeclarer);
        this.declareComplexParameterValue(model, dsl, config.getChildren(), (ParameterizedBuilder<String, ParameterValue, ?>)groupDeclarer);
        groupContainer.withParameterGroup((ParameterGroupElementDeclaration)groupDeclarer.getDeclaration());
    }

    private void declareComplexParameterValue(ParameterGroupModel group, DslElementSyntax groupDsl, List<ConfigLine> groupChilds, ParameterizedBuilder<String, ParameterValue, ?> groupBuilder) {
        groupChilds.forEach(child -> group.getParameterModels().stream().filter(param -> groupDsl.getChild(param.getName()).map(dsl -> dsl.getElementName().equals(child.getIdentifier())).orElse(false)).findFirst().ifPresent(param -> param.getType().accept(this.getParameterDeclarerVisitor((ConfigLine)child, (DslElementSyntax)groupDsl.getChild(param.getName()).get(), value -> groupBuilder.withParameter((Object)param.getName(), value)))));
    }

    private MetadataTypeVisitor getParameterDeclarerVisitor(final ConfigLine config, final DslElementSyntax paramDsl, final Consumer<ParameterValue> valueConsumer) {
        return new MetadataTypeVisitor(){

            protected void defaultVisit(MetadataType metadataType) {
                if (config.getTextContent() != null) {
                    valueConsumer.accept(DefaultXmlArtifactDeclarationLoader.this.isCData(config) ? ParameterSimpleValue.cdata((String)config.getTextContent()) : ParameterSimpleValue.plain((String)config.getTextContent()));
                }
            }

            public void visitArrayType(ArrayType arrayType) {
                ParameterListValue.Builder listBuilder = ElementDeclarer.newListValue();
                config.getChildren().forEach(item -> arrayType.getType().accept(DefaultXmlArtifactDeclarationLoader.this.getParameterDeclarerVisitor(item, (DslElementSyntax)paramDsl.getGeneric(arrayType.getType()).get(), arg_0 -> ((ParameterListValue.Builder)listBuilder).withValue(arg_0))));
                valueConsumer.accept(listBuilder.build());
            }

            public void visitObject(ObjectType objectType) {
                if (config.getConfigAttributes().isEmpty() && config.getChildren().isEmpty()) {
                    this.defaultVisit((MetadataType)objectType);
                    return;
                }
                ParameterObjectValue.Builder objectValue = ElementDeclarer.newObjectValue();
                if (ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
                    DefaultXmlArtifactDeclarationLoader.this.createMapValue(objectValue, config);
                } else if (paramDsl.isWrapped()) {
                    if (config.getChildren().size() == 1) {
                        DefaultXmlArtifactDeclarationLoader.this.createWrappedObject(objectType, objectValue, config);
                    }
                } else {
                    DefaultXmlArtifactDeclarationLoader.this.createObjectValueFromType(objectType, objectValue, config, paramDsl);
                }
                valueConsumer.accept(objectValue.build());
            }
        };
    }

    private void createMapValue(ParameterObjectValue.Builder objectValue, ConfigLine config) {
        config.getChildren().stream().map(ConfigLine::getConfigAttributes).forEach(entry -> {
            SimpleConfigAttribute entryKey = (SimpleConfigAttribute)entry.get("key");
            SimpleConfigAttribute entryValue = (SimpleConfigAttribute)entry.get("value");
            if (entryKey != null && entryValue != null) {
                objectValue.withParameter(entryKey.getValue(), entryValue.getValue());
            }
        });
    }

    private void createWrappedObject(ObjectType objectType, ParameterObjectValue.Builder objectValue, ConfigLine config) {
        ConfigLine wrappedConfig = config.getChildren().get(0);
        DslSyntaxResolver wrappedElementResolver = this.resolvers.get(this.extensionsByNamespace.get(wrappedConfig.getNamespace()));
        Set subTypes = this.context.getTypeCatalog().getSubTypes(objectType);
        if (!subTypes.isEmpty()) {
            subTypes.stream().filter(subType -> wrappedElementResolver.resolve((MetadataType)subType).map(dsl -> dsl.getElementName().equals(wrappedConfig.getIdentifier())).orElse(false)).findFirst().ifPresent(subType -> this.createObjectValueFromType((ObjectType)subType, objectValue, wrappedConfig, (DslElementSyntax)wrappedElementResolver.resolve((MetadataType)subType).get()));
        } else if (objectType.getAnnotation(ExtensibleTypeAnnotation.class).isPresent()) {
            this.createObjectValueFromType(objectType, objectValue, wrappedConfig, (DslElementSyntax)wrappedElementResolver.resolve((MetadataType)objectType).get());
        }
    }

    private void createObjectValueFromType(ObjectType objectType, ParameterObjectValue.Builder objectValue, ConfigLine config, DslElementSyntax paramDsl) {
        ExtensionMetadataTypeUtils.getId((MetadataType)objectType).ifPresent(arg_0 -> ((ParameterObjectValue.Builder)objectValue).ofType(arg_0));
        this.copyExplicitAttributes(config.getConfigAttributes(), (ParameterizedBuilder<String, ParameterValue, ?>)objectValue);
        config.getChildren().forEach(fieldConfig -> objectType.getFields().stream().filter(fieldType -> paramDsl.getContainedElement(MetadataTypeUtils.getLocalPart((ObjectFieldType)fieldType)).map(fieldDsl -> fieldDsl.getElementName().equals(fieldConfig.getIdentifier())).orElse(false)).findFirst().ifPresent(fieldType -> fieldType.getValue().accept(this.getParameterDeclarerVisitor((ConfigLine)fieldConfig, (DslElementSyntax)paramDsl.getContainedElement(MetadataTypeUtils.getLocalPart((ObjectFieldType)fieldType)).get(), fieldValue -> objectValue.withParameter(MetadataTypeUtils.getLocalPart((ObjectFieldType)fieldType), fieldValue)))));
    }

    private void handleInfrastructure(ParameterModel paramModel, List<ConfigLine> declaredConfigs, ParameterizedElementDeclarer declarer) {
        switch (paramModel.getName()) {
            case "reconnection": {
                this.findAnyMatchingChildById(declaredConfigs, "reconnection").ifPresent(config -> {
                    ParameterObjectValue.Builder reconnection = ElementDeclarer.newObjectValue().ofType(config.getIdentifier());
                    this.copyExplicitAttributes(config.getConfigAttributes(), (ParameterizedBuilder<String, ParameterValue, ?>)reconnection);
                    config.getChildren().forEach(child -> {
                        String paramName = child.getIdentifier().equals("reconnect") || child.getIdentifier().equals("reconnect-forever") ? "reconnectionStrategy" : child.getIdentifier();
                        ParameterObjectValue.Builder childBuilder = ElementDeclarer.newObjectValue().ofType(child.getIdentifier());
                        this.cloneAsDeclaration((ConfigLine)child, childBuilder);
                        reconnection.withParameter(paramName, (ParameterValue)childBuilder.build());
                    });
                    declarer.withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Connection").withParameter("reconnection", (ParameterValue)reconnection.build()).getDeclaration());
                });
                return;
            }
            case "reconnectionStrategy": {
                this.findAnyMatchingChildById(declaredConfigs, "reconnect", "reconnect-forever").ifPresent(config -> {
                    ParameterObjectValue.Builder reconnection = ElementDeclarer.newObjectValue().ofType(config.getIdentifier());
                    this.copyExplicitAttributes(config.getConfigAttributes(), (ParameterizedBuilder<String, ParameterValue, ?>)reconnection);
                    declarer.withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Connection").withParameter("reconnectionStrategy", (ParameterValue)reconnection.build()).getDeclaration());
                });
                return;
            }
            case "redeliveryPolicy": {
                this.findAnyMatchingChildById(declaredConfigs, "redelivery-policy").ifPresent(config -> {
                    ParameterObjectValue.Builder redelivery = ElementDeclarer.newObjectValue();
                    this.copyExplicitAttributes(config.getConfigAttributes(), (ParameterizedBuilder<String, ParameterValue, ?>)redelivery);
                    declarer.withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("redeliveryPolicy", (ParameterValue)redelivery.build()).getDeclaration());
                });
                return;
            }
            case "poolingProfile": {
                this.findAnyMatchingChildById(declaredConfigs, "pooling-profile").ifPresent(config -> {
                    ParameterObjectValue.Builder poolingProfile = ElementDeclarer.newObjectValue();
                    this.cloneAsDeclaration((ConfigLine)config, poolingProfile);
                    declarer.withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Connection").withParameter("poolingProfile", (ParameterValue)poolingProfile.build()).getDeclaration());
                });
                return;
            }
            case "streamingStrategy": {
                this.findAnyMatchingChildById(declaredConfigs, "repeatable-file-store-stream", "repeatable-in-memory-stream", "non-repeatable-stream").ifPresent(config -> {
                    ParameterObjectValue.Builder streaming = ElementDeclarer.newObjectValue().ofType(config.getIdentifier());
                    this.cloneAsDeclaration((ConfigLine)config, streaming);
                    declarer.withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("streamingStrategy", (ParameterValue)streaming.build()).getDeclaration());
                });
                return;
            }
            case "tlsContext": {
                this.findAnyMatchingChildById(declaredConfigs, "context").ifPresent(config -> {
                    ParameterObjectValue.Builder tls = ElementDeclarer.newObjectValue();
                    this.cloneAsDeclaration((ConfigLine)config, tls);
                    declarer.withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("tlsContext", (ParameterValue)tls.build()).getDeclaration());
                });
                return;
            }
        }
    }

    private Optional<ConfigLine> findAnyMatchingChildById(List<ConfigLine> configs, String ... validIds) {
        List<String> ids = Arrays.asList(validIds);
        return configs.stream().filter(c -> ids.contains(c.getIdentifier())).findFirst();
    }

    private void cloneAsDeclaration(ConfigLine config, ParameterObjectValue.Builder poolingProfile) {
        this.copyExplicitAttributes(config.getConfigAttributes(), (ParameterizedBuilder<String, ParameterValue, ?>)poolingProfile);
        this.copyChildren(config, (ParameterizedBuilder<String, ParameterValue, ?>)poolingProfile);
    }

    private String getNamespace(ConfigLine configLine) {
        return configLine.getNamespace() == null ? "mule" : configLine.getNamespace();
    }

    private void copyExplicitAttributes(Map<String, SimpleConfigAttribute> attributes, ParameterizedBuilder<String, ParameterValue, ?> builder) {
        attributes.values().stream().filter(a -> !a.getName().equals("name") && !a.getName().equals("config-ref")).filter(a -> !a.isValueFromSchema()).forEach(a -> builder.withParameter((Object)a.getName(), (Object)ParameterSimpleValue.of((String)a.getValue())));
    }

    private void copyExplicitAttributes(ParameterizedModel model, Map<String, SimpleConfigAttribute> attributes, ParameterizedElementDeclarer builder) {
        attributes.values().stream().filter(a -> !a.getName().equals("name") && !a.getName().equals("config-ref")).filter(a -> !a.isValueFromSchema()).forEach(a -> {
            Optional<ParameterGroupModel> ownerGroup = model.getParameterGroupModels().stream().filter(group -> group.getParameter(a.getName()).isPresent()).findFirst();
            if (ownerGroup.isPresent()) {
                builder.withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)ownerGroup.get().getName()).withParameter(a.getName(), ParameterSimpleValue.of((String)a.getValue())).getDeclaration());
            } else {
                builder.withCustomParameter(a.getName(), a.getValue());
            }
        });
    }

    private void copyChildren(ConfigLine config, ParameterizedBuilder<String, ParameterValue, ?> builder) {
        config.getChildren().forEach(child -> {
            ParameterObjectValue.Builder childBuilder = ElementDeclarer.newObjectValue();
            this.cloneAsDeclaration((ConfigLine)child, childBuilder);
            builder.withParameter((Object)child.getIdentifier(), (Object)childBuilder.build());
        });
    }
}

