/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.internal;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.TreeTraverser;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.runtime.config.spring.internal.BeanDependencyResolver;
import org.mule.runtime.config.spring.internal.SpringRegistry;
import org.mule.runtime.config.spring.internal.dsl.model.ConfigurationDependencyResolver;

public class DefaultBeanDependencyResolver
implements BeanDependencyResolver {
    private final SpringRegistry springRegistry;
    private final ConfigurationDependencyResolver configurationDependencyResolver;

    public DefaultBeanDependencyResolver(ConfigurationDependencyResolver configurationDependencyResolver, SpringRegistry springRegistry) {
        this.configurationDependencyResolver = configurationDependencyResolver;
        this.springRegistry = springRegistry;
    }

    @Override
    public Collection<Object> resolveBeanDependencies(Set<String> beanNames) {
        DependencyNode node;
        DependencyNode root = new DependencyNode(null);
        for (String beanName : beanNames) {
            this.addDependency(root, beanName, this.springRegistry.get(beanName));
        }
        FluentIterable orderedNodes = new TreeTraverser<DependencyNode>(){

            public Iterable children(DependencyNode node) {
                return node.getChildren();
            }
        }.postOrderTraversal((Object)root);
        LinkedList<Object> orderedObjects = new LinkedList<Object>();
        Iterator iterator = orderedNodes.iterator();
        while (iterator.hasNext() && (node = (DependencyNode)iterator.next()) != root) {
            orderedObjects.add(node.getValue());
        }
        return orderedObjects;
    }

    private void addDependency(DependencyNode parent, String key, Object object) {
        this.addDependency(parent, key, object, new HashSet<String>());
    }

    private void addDependency(DependencyNode parent, String key, Object object, Set<String> processedKeys) {
        DependencyNode node = new DependencyNode(object);
        parent.addChild(node);
        if (!processedKeys.contains(key)) {
            processedKeys.add(key);
            for (Map.Entry<String, Object> dependency : this.springRegistry.getDependencies(key).entrySet()) {
                this.addDependency(node, dependency.getKey(), dependency.getValue(), processedKeys);
            }
            Collection<String> dependencies = this.configurationDependencyResolver.resolveComponentDependencies(key);
            for (String dependency : dependencies) {
                if (!this.springRegistry.isSingleton(dependency)) continue;
                this.addDependency(node, dependency, this.springRegistry.get(dependency), processedKeys);
            }
        }
    }

    private class DependencyNode {
        private final Object value;
        private final List<DependencyNode> children = new LinkedList<DependencyNode>();

        private DependencyNode(Object value) {
            this.value = value;
        }

        public DependencyNode addChild(DependencyNode child) {
            this.children.add(child);
            return this;
        }

        public List<DependencyNode> getChildren() {
            return this.children;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

