/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.parsers.processors;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.mule.runtime.config.spring.parsers.PreProcessor;
import org.mule.runtime.config.spring.parsers.assembly.configuration.PropertyConfiguration;
import org.mule.runtime.config.spring.util.SpringXMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class BlockAttribute
implements PreProcessor {
    private Set<String> disallowed;

    public BlockAttribute(String disallowed) {
        this(new String[]{disallowed});
    }

    public BlockAttribute(String[] disallowed) {
        this.disallowed = new HashSet<String>(Arrays.asList(disallowed));
    }

    @Override
    public void preProcess(PropertyConfiguration config, Element element) {
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String alias = SpringXMLUtils.attributeName((Attr)attributes.item(i));
            String name = config.translateName(alias);
            if (!this.disallowed.contains(name)) continue;
            throw new BlockAttributeException("Attribute " + alias + " is not allowed here.");
        }
    }

    public static class BlockAttributeException
    extends IllegalStateException {
        BlockAttributeException(String message) {
            super(message);
        }
    }
}

