/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.lang.reflect.Field;
import java.util.Optional;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.runtime.ValueResolvingException;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public class ObjectBasedParameterValueResolver
implements ParameterValueResolver {
    private final Object object;
    private final ParameterizedModel parameterizedModel;
    private final ReflectionCache reflectionCache;

    public ObjectBasedParameterValueResolver(Object object, ParameterizedModel parameterizedModel, ReflectionCache reflectionCache) {
        this.object = object;
        this.parameterizedModel = parameterizedModel;
        this.reflectionCache = reflectionCache;
    }

    @Override
    public Object getParameterValue(String parameterName) throws ValueResolvingException {
        try {
            Optional<Field> field = IntrospectionUtils.getField(this.object.getClass(), parameterName, this.reflectionCache);
            if (field.isPresent()) {
                return IntrospectionUtils.getFieldValue(this.object, parameterName, this.reflectionCache);
            }
            for (ParameterGroupModel parameterGroupModel : this.parameterizedModel.getParameterGroupModels()) {
                ParameterGroupModelProperty property;
                Field container;
                Object parameterGroup;
                Optional<Field> desiredField;
                Optional modelProperty = parameterGroupModel.getModelProperty(ParameterGroupModelProperty.class);
                if (!modelProperty.isPresent() || !(desiredField = IntrospectionUtils.getField((parameterGroup = IntrospectionUtils.getFieldValue(this.object, (container = (Field)(property = (ParameterGroupModelProperty)modelProperty.get()).getDescriptor().getContainer()).getName(), this.reflectionCache)).getClass(), parameterName, this.reflectionCache)).isPresent()) continue;
                return IntrospectionUtils.getFieldValue(parameterGroup, parameterName, this.reflectionCache);
            }
        }
        catch (Exception e) {
            throw new ValueResolvingException("An error occurred trying to obtain the value for the parameter: " + parameterName);
        }
        throw new ValueResolvingException("Unable to resolve value for the parameter: " + parameterName);
    }
}

