/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.manager;

import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.error.ErrorModelBuilder;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.core.api.exception.ErrorTypeLocator;
import org.mule.runtime.core.api.exception.ErrorTypeRepository;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.core.api.exception.ExceptionMapper;
import org.mule.runtime.core.api.retry.policy.RetryPolicyExhaustedException;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.dsl.syntax.resolver.ImportTypesStrategy;
import org.mule.runtime.extension.api.dsl.syntax.resolver.SingleExtensionImportTypesStrategy;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

class ExtensionErrorsRegistrant {
    public static final String MULE = Errors.CORE_NAMESPACE_NAME;
    private final ErrorTypeRepository errorTypeRepository;
    private final ErrorTypeLocator errorTypeLocator;

    ExtensionErrorsRegistrant(ErrorTypeRepository errorTypeRepository, ErrorTypeLocator errorTypeLocator) {
        this.errorTypeRepository = errorTypeRepository;
        this.errorTypeLocator = errorTypeLocator;
    }

    void registerErrors(ExtensionModel extensionModel) {
        final Set errorTypes = extensionModel.getErrorModels();
        final String extensionNamespace = extensionModel.getXmlDslModel().getPrefix();
        String errorExtensionNamespace = MuleExtensionUtils.getExtensionsErrorNamespace(extensionModel);
        final DslSyntaxResolver syntaxResolver = DslSyntaxResolver.getDefault((ExtensionModel)extensionModel, (ImportTypesStrategy)new SingleExtensionImportTypesStrategy());
        final ErrorModel connectivityErrorModel = ErrorModelBuilder.newError((String)"CONNECTIVITY", (String)errorExtensionNamespace).withParent(ErrorModelBuilder.newError((String)"CONNECTIVITY", (String)MULE).build()).build();
        final ErrorModel retryExhaustedError = ErrorModelBuilder.newError((String)"RETRY_EXHAUSTED", (String)errorExtensionNamespace).withParent(ErrorModelBuilder.newError((String)"RETRY_EXHAUSTED", (String)MULE).build()).build();
        errorTypes.forEach(this::getErrorType);
        IdempotentExtensionWalker extensionWalker = new IdempotentExtensionWalker(){

            protected void onOperation(OperationModel model) {
                if (!errorTypes.isEmpty()) {
                    ExceptionMapper.Builder builder = ExceptionMapper.builder();
                    builder.addExceptionMapping(ConnectionException.class, ExtensionErrorsRegistrant.this.getErrorType(connectivityErrorModel));
                    builder.addExceptionMapping(RetryPolicyExhaustedException.class, ExtensionErrorsRegistrant.this.getErrorType(retryExhaustedError));
                    String elementName = syntaxResolver.resolve((NamedObject)model).getElementName();
                    ExtensionErrorsRegistrant.this.errorTypeLocator.addComponentExceptionMapper(ExtensionErrorsRegistrant.createIdentifier(elementName, extensionNamespace), builder.build());
                }
            }
        };
        extensionWalker.walk(extensionModel);
    }

    private ErrorType getErrorType(ErrorModel errorModel) {
        ComponentIdentifier identifier = ExtensionErrorsRegistrant.createIdentifier(errorModel.getType(), errorModel.getNamespace());
        Optional optionalError = this.errorTypeRepository.getErrorType(identifier);
        return optionalError.orElseGet(() -> this.createErrorType(errorModel, identifier));
    }

    private ErrorType createErrorType(ErrorModel errorModel, ComponentIdentifier identifier) {
        ErrorType errorType = errorModel.getParent().isPresent() ? this.errorTypeRepository.addErrorType(identifier, this.getErrorType((ErrorModel)errorModel.getParent().get())) : this.errorTypeRepository.addErrorType(identifier, null);
        return errorType;
    }

    private static ComponentIdentifier createIdentifier(String name, String namespace) {
        return ComponentIdentifier.builder().name(name).namespace(namespace).build();
    }
}

