/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.java.api.utils;

import org.mule.metadata.api.builder.TypeBuilder;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ParsingContext {

  private final Map<TypeVariable<?>, Type> resolvedVariables = new HashMap<>();
  private final Map<Type, TypeBuilder<?>> typedObjects = new HashMap<>();

  public Optional<TypeBuilder<?>> getTypeBuilder(Type type) {
    return Optional.ofNullable(typedObjects.get(type));
  }

  public void addTypeBuilder(Type type, TypeBuilder<?> typedObject) {
    if (!typedObjects.containsKey(type)) {
      typedObjects.put(type, typedObject);
    }
  }

  public Map<TypeVariable<?>, Type> getResolvedVariables() {
    return Collections.unmodifiableMap(resolvedVariables);
  }

  public void addResolvedVariables(Map<TypeVariable<?>, Type> map) {
    for (Map.Entry<TypeVariable<?>, Type> entry : map.entrySet()) {
      if (resolvedVariables.containsKey(entry.getKey())) {
        // only replace if value is something usable
        if (!(entry.getValue() instanceof TypeVariable<?>)) {
          resolvedVariables.put(entry.getKey(), entry.getValue());
        }
      } else {
        resolvedVariables.put(entry.getKey(), entry.getValue());
      }
    }
  }
}
