/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.ast.internal.handler;

import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.Date;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import javax.xml.datatype.XMLGregorianCalendar;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.ast.api.IntrospectionContext;
import org.mule.metadata.ast.internal.ASTHelper;
import org.mule.metadata.ast.internal.handler.BaseTypeHandler;

public class DateTypeHandler
extends BaseTypeHandler {
    public DateTypeHandler(ProcessingEnvironment processingEnvironment) {
        super(processingEnvironment, Calendar.class, XMLGregorianCalendar.class, Temporal.class, Date.class, java.sql.Date.class);
    }

    @Override
    public TypeBuilder<?> handle(TypeMirror typeMirror, TypeVisitor<TypeBuilder<?>, IntrospectionContext> visitor, IntrospectionContext context) {
        MetadataTypeUtils.checkArgument((boolean)(typeMirror instanceof DeclaredType), (String)"The given type should be a DeclaredType");
        DeclaredType declaredType = (DeclaredType)typeMirror;
        if (this.astHelper.isAssignable(declaredType, Calendar.class, XMLGregorianCalendar.class, Temporal.class)) {
            return this.builder().dateTimeType().id(ASTHelper.typeId(declaredType));
        }
        if (this.astHelper.isAssignable(declaredType, Date.class, java.sql.Date.class)) {
            return this.builder().dateType().id(ASTHelper.typeId(declaredType));
        }
        throw new IllegalArgumentException("The given TypeMirror is not handleable. " + typeMirror);
    }
}

