/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.transformer;

import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.xml.stax.ReversibleXMLStreamReader;
import org.mule.module.xml.transformer.AbstractXmlTransformer;
import org.mule.module.xml.util.XMLUtils;
import org.mule.transformer.types.DataTypeFactory;
import org.w3c.dom.Document;

public class XmlToXMLStreamReader
extends AbstractXmlTransformer
implements DiscoverableTransformer {
    private int priorityWeighting = 1;
    private boolean reversible;

    public XmlToXMLStreamReader() {
        this.registerSourceType(Source.class);
        this.registerSourceType(InputStream.class);
        this.registerSourceType(Document.class);
        this.registerSourceType(byte[].class);
        this.registerSourceType(String.class);
        this.setReturnDataType(DataTypeFactory.create(XMLStreamReader.class));
    }

    public Object transformMessage(MuleMessage message, String encoding) throws TransformerException {
        Object src = message.getPayload();
        try {
            XMLStreamReader xsr = XMLUtils.toXMLStreamReader(this.getXMLInputFactory(), src);
            if (xsr == null) {
                throw new TransformerException(MessageFactory.createStaticMessage((String)("Unable to convert " + src.getClass() + " to XMLStreamReader.")), (Transformer)this);
            }
            if (this.reversible && !(xsr instanceof ReversibleXMLStreamReader)) {
                return new ReversibleXMLStreamReader(xsr);
            }
            return xsr;
        }
        catch (XMLStreamException e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
    }

    public boolean isReversible() {
        return this.reversible;
    }

    public void setReversible(boolean reversible) {
        this.reversible = reversible;
    }

    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }
}

