/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.transformer;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.xml.transformer.XStreamFactory;
import org.mule.transformer.AbstractMessageAwareTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXStreamTransformer
extends AbstractMessageAwareTransformer {
    private final AtomicReference xstream = new AtomicReference();
    private volatile String driverClass = "com.thoughtworks.xstream.io.xml.XppDriver";
    private volatile Map<String, Class> aliases = new HashMap<String, Class>();
    private volatile Set<Class<? extends Converter>> converters = new HashSet<Class<? extends Converter>>();

    public final XStream getXStream() throws TransformerException {
        XStream instance = (XStream)this.xstream.get();
        if (instance == null) {
            try {
                instance = new XStreamFactory(this.driverClass, this.aliases, this.converters).getInstance();
                if (!this.xstream.compareAndSet(null, (Object)instance)) {
                    instance = (XStream)this.xstream.get();
                }
            }
            catch (Exception e) {
                throw new TransformerException(MessageFactory.createStaticMessage((String)"Unable to initialize XStream"), (Throwable)e);
            }
        }
        return instance;
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractXStreamTransformer clone = (AbstractXStreamTransformer)((Object)super.clone());
        clone.setDriverClass(this.driverClass);
        if (this.aliases != null) {
            clone.setAliases(new HashMap<String, Class>(this.aliases));
        }
        if (this.converters != null) {
            clone.setConverters(new HashSet<Class<? extends Converter>>(this.converters));
        }
        return clone;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
        this.xstream.set(null);
    }

    public Map<String, Class> getAliases() {
        return this.aliases;
    }

    public void setAliases(Map<String, Class> aliases) {
        this.aliases = aliases;
        this.xstream.set(null);
    }

    public Set<Class<? extends Converter>> getConverters() {
        return this.converters;
    }

    public void setConverters(Set<Class<? extends Converter>> converters) {
        this.converters = converters;
        this.xstream.set(null);
    }

    public void initialise() throws InitialisationException {
        super.initialise();
        try {
            this.getXStream();
        }
        catch (TransformerException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public void addAlias(String alias, Class aClass) {
        this.aliases.put(alias, aClass);
    }

    public Class removeAlias(String alias) {
        return this.aliases.remove(alias);
    }

    public void addConverter(Class<? extends Converter> converterClass) {
        this.converters.add(converterClass);
    }

    public boolean removeAlias(Class<? extends Converter> converterClass) {
        return this.converters.remove(converterClass);
    }
}

