/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.xml;

import java.io.IOException;
import java.io.OutputStream;
import org.dom4j.Document;
import org.mule.transformers.xml.AbstractXmlTransformer;
import org.mule.umo.UMOEvent;
import org.mule.umo.provider.OutputHandler;
import org.mule.umo.transformer.DiscoverableTransformer;
import org.mule.umo.transformer.TransformerException;

public class DocumentToOutputHandler
extends AbstractXmlTransformer
implements DiscoverableTransformer {
    private int priorityWeighting = 1;

    public DocumentToOutputHandler() {
        this.registerSourceType(Document.class);
        this.registerSourceType(org.w3c.dom.Document.class);
        this.setReturnClass(OutputHandler.class);
    }

    public Object doTransform(final Object src, final String encoding) throws TransformerException {
        return new OutputHandler(){

            public void write(UMOEvent event, OutputStream out) throws IOException {
                try {
                    out.write(DocumentToOutputHandler.this.convertToBytes(src, encoding).getBytes());
                }
                catch (javax.xml.transform.TransformerException e) {
                    throw new IOException(e.toString());
                }
            }
        };
    }

    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }
}

