/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ws.consumer;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Types;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaReference;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

public class WSDLUtils {
    private static final String XML_NS_PREFIX = "xmlns:";

    public static List<String> getSchemas(Definition wsdlDefinition) throws TransformerException {
        Map wsdlNamespaces = wsdlDefinition.getNamespaces();
        ArrayList<String> schemas = new ArrayList<String>();
        Types types = wsdlDefinition.getTypes();
        if (types != null) {
            for (Object o : types.getExtensibilityElements()) {
                if (!(o instanceof Schema)) continue;
                Schema schema = (Schema)o;
                for (Map.Entry entry : wsdlNamespaces.entrySet()) {
                    if (schema.getElement().hasAttribute(XML_NS_PREFIX + (String)entry.getKey())) continue;
                    schema.getElement().setAttribute(XML_NS_PREFIX + (String)entry.getKey(), (String)entry.getValue());
                }
                schemas.add(WSDLUtils.schemaToString(schema));
                for (Map.Entry location : schema.getIncludes()) {
                    schemas.add(WSDLUtils.schemaToString(((SchemaReference)location).getReferencedSchema()));
                }
            }
        }
        return schemas;
    }

    public static String schemaToString(Schema schema) throws TransformerException {
        StringWriter writer = new StringWriter();
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.transform(new DOMSource(schema.getElement()), new StreamResult(writer));
        return writer.toString();
    }

    public static SOAPBody getSoapBody(BindingOperation bindingOperation) {
        List extensions = bindingOperation.getBindingInput().getExtensibilityElements();
        for (Object extension : extensions) {
            if (!(extension instanceof SOAPBody)) continue;
            return (SOAPBody)extension;
        }
        return null;
    }
}

