/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ws.consumer;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.mule.common.metadata.DefaultXmlMetaDataModel;
import org.mule.common.metadata.MetaDataModelProperty;
import org.mule.module.ws.consumer.WSDLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestBodyGenerator {
    private static final Logger logger = LoggerFactory.getLogger(RequestBodyGenerator.class);
    private Definition wsdlDefinition;

    public RequestBodyGenerator(Definition wsdlDefinition) {
        this.wsdlDefinition = wsdlDefinition;
    }

    public String generateRequestBody(BindingOperation bindingOperation) {
        List<String> schemas;
        try {
            schemas = WSDLUtils.getSchemas(this.wsdlDefinition);
        }
        catch (TransformerException e) {
            logger.warn("Unable to get schemas from WSDL, cannot check if the operation requires input parameters", (Throwable)e);
            return null;
        }
        SOAPBody soapBody = WSDLUtils.getSoapBody(bindingOperation);
        if (soapBody == null) {
            logger.warn("No SOAP body defined in the WSDL for the specified operation, cannot check if the operation requires input parameters");
            return null;
        }
        Part part = this.getSinglePart(soapBody, bindingOperation.getOperation().getInput().getMessage());
        if (part == null || part.getElementName() == null) {
            return null;
        }
        DefaultXmlMetaDataModel model = new DefaultXmlMetaDataModel(schemas, part.getElementName(), Charset.defaultCharset(), new MetaDataModelProperty[0]);
        if (model.getFields().isEmpty()) {
            logger.info("The selected operation does not require input parameters, the payload will be ignored");
            QName element = part.getElementName();
            return String.format("<ns:%s xmlns:ns=\"%s\" />", element.getLocalPart(), element.getNamespaceURI());
        }
        return null;
    }

    private Part getSinglePart(SOAPBody soapBody, Message inputMessage) {
        if (soapBody.getParts() == null || soapBody.getParts().isEmpty()) {
            Map parts = inputMessage.getParts();
            if (parts.size() == 1) {
                return (Part)parts.values().iterator().next();
            }
        } else if (soapBody.getParts().size() == 1) {
            String partName = (String)soapBody.getParts().get(0);
            return inputMessage.getPart(partName);
        }
        return null;
    }
}

