/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extras.spring.remoting;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractTransformer;
import org.springframework.remoting.support.RemoteInvocation;

public class ObjectToRemoteInvocationTransformer
extends AbstractTransformer {
    public ObjectToRemoteInvocationTransformer() {
        this.registerSourceType(RemoteInvocation.class);
        this.registerSourceType(byte[].class);
        this.setReturnClass(RemoteInvocation.class);
    }

    protected Object doTransform(Object src, String encoding) throws TransformerException {
        if (src instanceof RemoteInvocation) {
            return src;
        }
        try {
            byte[] data = (byte[])src;
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            ObjectInputStream ois = new ObjectInputStream(bais);
            Object o = ois.readObject();
            RemoteInvocation ri = (RemoteInvocation)o;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("request to execute " + ri.getMethodName()));
                for (int i = 0; i < ri.getArguments().length; ++i) {
                    Object a = ri.getArguments()[i];
                    this.logger.debug((Object)("with argument (" + a.toString() + ")"));
                }
            }
            return ri;
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
    }
}

