/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.factories;

import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.lifecycle.LifecycleUtils;
import org.mule.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;

public class ConstantFactoryBean<T>
implements FactoryBean<T>,
MuleContextAware,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConstantFactoryBean.class);
    private final T value;

    public ConstantFactoryBean(T value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"value cannot be null");
        this.value = value;
    }

    public T getObject() throws Exception {
        return this.value;
    }

    public boolean isSingleton() {
        return true;
    }

    public Class<?> getObjectType() {
        return this.value.getClass();
    }

    public void setMuleContext(MuleContext context) {
        if (this.value instanceof MuleContextAware) {
            ((MuleContextAware)this.value).setMuleContext(context);
        }
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.value);
    }

    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.value);
    }

    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.value);
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.value, (Logger)LOGGER);
    }
}

