/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.specific;

import java.io.InputStream;
import org.mule.config.spring.parsers.assembly.BeanAssembler;
import org.mule.config.spring.parsers.generic.ChildDefinitionParser;
import org.mule.util.IOUtils;
import org.mule.util.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.w3c.dom.Element;

public class DataObjectDefinitionParser
extends ChildDefinitionParser {
    public DataObjectDefinitionParser(String setterMethod) {
        super(setterMethod, DataObjectFactoryBean.class);
    }

    public DataObjectDefinitionParser(String setterMethod, Class constraint) {
        super(setterMethod, DataObjectFactoryBean.class, constraint);
    }

    public DataObjectDefinitionParser(String setterMethod, Class constraint, boolean allowClassAttribute) {
        super(setterMethod, DataObjectFactoryBean.class, constraint, allowClassAttribute);
    }

    @Override
    protected void postProcess(ParserContext context, BeanAssembler assembler, Element element) {
        if (StringUtils.isNotEmpty((String)element.getTextContent())) {
            assembler.extendBean("data", element.getTextContent(), false);
        }
        super.postProcess(context, assembler, element);
    }

    public static class DataObjectFactoryBean
    implements FactoryBean,
    ApplicationContextAware {
        private String ref;
        private boolean binary;
        private String file;
        private Object data;
        private ApplicationContext context;

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            this.context = applicationContext;
        }

        public Object getObject() throws Exception {
            if (this.data != null) {
                return this.data;
            }
            if (this.file != null) {
                this.data = this.binary ? (Object)IOUtils.toByteArray((InputStream)IOUtils.getResourceAsStream((String)this.file, this.getClass())) : IOUtils.getResourceAsString((String)this.file, this.getClass());
            } else if (this.ref != null) {
                this.data = this.context.getBean(this.ref);
            }
            if (this.data == null) {
                throw new IllegalArgumentException("Data is null was not found");
            }
            return this.data;
        }

        public Class getObjectType() {
            return Object.class;
        }

        public boolean isSingleton() {
            return true;
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public String getRef() {
            return this.ref;
        }

        public void setRef(String ref) {
            this.ref = ref;
        }

        public Object getData() {
            return this.data;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public boolean isBinary() {
            return this.binary;
        }

        public void setBinary(boolean binary) {
            this.binary = binary;
        }
    }
}

