/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.DOMReader;
import org.mule.api.MuleContext;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.construct.Pipeline;
import org.mule.common.MuleArtifact;
import org.mule.common.MuleArtifactFactoryException;
import org.mule.common.config.XmlConfigurationCallback;
import org.mule.common.config.XmlConfigurationMuleArtifactFactory;
import org.mule.config.ConfigResource;
import org.mule.config.spring.DefaultMuleArtifact;
import org.mule.config.spring.SpringXmlConfigurationBuilder;
import org.mule.context.DefaultMuleContextFactory;
import org.w3c.dom.Element;

public class SpringXmlConfigurationMuleArtifactFactory
implements XmlConfigurationMuleArtifactFactory {
    private Map<MuleArtifact, SpringXmlConfigurationBuilder> builders = new HashMap<MuleArtifact, SpringXmlConfigurationBuilder>();
    private Map<MuleArtifact, MuleContext> contexts = new HashMap<MuleArtifact, MuleContext>();

    public MuleArtifact getArtifact(Element element, XmlConfigurationCallback callback) throws MuleArtifactFactoryException {
        return this.doGetArtifact(element, callback, false);
    }

    public MuleArtifact getArtifactForMessageProcessor(Element element, XmlConfigurationCallback callback) throws MuleArtifactFactoryException {
        return this.doGetArtifact(element, callback, true);
    }

    private MuleArtifact doGetArtifact(Element element, XmlConfigurationCallback callback, boolean embedInFlow) throws MuleArtifactFactoryException {
        org.dom4j.Element rootElement;
        ConfigResource config = null;
        Document document = DocumentHelper.createDocument();
        org.dom4j.Element parentElement = rootElement = document.addElement("mule", "http://www.mulesoft.org/schema/mule/core");
        this.addSchemaLocation(rootElement, element, callback);
        String flowName = "flow-" + Integer.toString(element.hashCode());
        if (embedInFlow) {
            parentElement = rootElement.addElement("flow", "http://www.mulesoft.org/schema/mule/core");
            parentElement.addAttribute("name", flowName);
        }
        try {
            parentElement.add(this.convert(element));
            for (int i = 0; i < element.getAttributes().getLength(); ++i) {
                Element dependentElement;
                String attributeName = element.getAttributes().item(i).getLocalName();
                if (attributeName == null || !attributeName.endsWith("-ref") || (dependentElement = callback.getGlobalElement(element.getAttributes().item(i).getNodeValue())) == null) continue;
                if ("http://www.springframework.org/schema/beans".equals(dependentElement.getNamespaceURI())) {
                    String namespaceUri = dependentElement.getNamespaceURI();
                    Namespace namespace = new Namespace(dependentElement.getPrefix(), namespaceUri);
                    org.dom4j.Element beans = rootElement.element(new QName("beans", namespace));
                    if (beans == null) {
                        beans = rootElement.addElement("beans", namespaceUri);
                    }
                    beans.add(this.convert(dependentElement));
                } else {
                    rootElement.add(this.convert(dependentElement));
                    this.addSchemaLocation(rootElement, dependentElement, callback);
                }
                this.addChildSchemaLocations(rootElement, dependentElement, callback);
            }
            config = new ConfigResource("", (InputStream)new StringBufferInputStream(document.asXML()));
        }
        catch (Exception e) {
            throw new MuleArtifactFactoryException("Error parsing XML", (Throwable)e);
        }
        MuleContext muleContext = null;
        SpringXmlConfigurationBuilder builder = null;
        try {
            DefaultMuleContextFactory factory = new DefaultMuleContextFactory();
            builder = new SpringXmlConfigurationBuilder(new ConfigResource[]{config});
            muleContext = factory.createMuleContext((ConfigurationBuilder)builder);
            muleContext.start();
            DefaultMuleArtifact artifact = null;
            if (embedInFlow) {
                Pipeline pipeline = (Pipeline)muleContext.getRegistry().lookupFlowConstruct(flowName);
                artifact = new DefaultMuleArtifact(pipeline.getMessageProcessors().get(0));
            } else {
                artifact = new DefaultMuleArtifact(muleContext.getRegistry().lookupObject(element.getAttribute("name")));
            }
            this.builders.put(artifact, builder);
            this.contexts.put(artifact, muleContext);
            return artifact;
        }
        catch (Exception e) {
            this.dispose(builder, muleContext);
            throw new MuleArtifactFactoryException("Error initializing", (Throwable)e);
        }
    }

    protected void addSchemaLocation(org.dom4j.Element rootElement, Element element, XmlConfigurationCallback callback) {
        StringBuffer schemaLocation = new StringBuffer();
        schemaLocation.append("http://www.mulesoft.org/schema/mule/core http://www.mulesoft.org/schema/mule/core/current/mule.xsd\n");
        schemaLocation.append(element.getNamespaceURI() + " " + callback.getSchemaLocation(element.getNamespaceURI()));
        rootElement.addAttribute(QName.get((String)"schemaLocation", (String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"), schemaLocation.toString());
    }

    protected void addChildSchemaLocations(org.dom4j.Element rootElement, Element element, XmlConfigurationCallback callback) {
    }

    public org.dom4j.Element convert(Element element) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        org.w3c.dom.Document doc1 = builder.newDocument();
        Element importedElement = (Element)doc1.importNode(element, Boolean.TRUE);
        doc1.appendChild(importedElement);
        DOMReader reader = new DOMReader();
        Document doc2 = reader.read(doc1);
        return doc2.getRootElement();
    }

    public void returnArtifact(MuleArtifact artifact) {
        SpringXmlConfigurationBuilder builder = this.builders.remove(artifact);
        MuleContext context = this.contexts.remove(artifact);
        this.dispose(builder, context);
    }

    private void dispose(SpringXmlConfigurationBuilder builder, MuleContext context) {
        if (context != null) {
            context.dispose();
        }
        this.deleteLoggingThreads();
    }

    private void deleteLoggingThreads() {
        String[] threadsToDelete = new String[]{"Mule.log.clogging.ref.handler", "Mule.log.slf4j.ref.handler"};
        Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
        Thread[] threadArray = threadSet.toArray(new Thread[threadSet.size()]);
        for (String threadToDelete : threadsToDelete) {
            for (Thread t : threadArray) {
                if (!threadToDelete.equals(t.getName())) continue;
                try {
                    t.interrupt();
                }
                catch (SecurityException e) {
                    // empty catch block
                }
            }
        }
    }
}

