/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.factories;

import java.util.List;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorBuilder;
import org.mule.api.processor.MessageProcessors;
import org.mule.api.transaction.TransactionFactory;
import org.mule.processor.DelegateTransactionFactory;
import org.mule.processor.TransactionalInterceptingMessageProcessor;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.transaction.MuleTransactionConfig;
import org.springframework.beans.factory.FactoryBean;

public class TransactionalMessageProcessorsFactoryBean
implements FactoryBean {
    protected List messageProcessors;
    protected MessagingExceptionHandler exceptionListener;
    protected String action;

    public Class getObjectType() {
        return TransactionalInterceptingMessageProcessor.class;
    }

    public void setMessageProcessors(List messageProcessors) {
        this.messageProcessors = messageProcessors;
    }

    public Object getObject() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.setName("'transaction' child processor chain");
        TransactionalInterceptingMessageProcessor txProcessor = new TransactionalInterceptingMessageProcessor();
        txProcessor.setExceptionListener(this.exceptionListener);
        MuleTransactionConfig transactionConfig = this.createTransactionConfig(this.action);
        txProcessor.setTransactionConfig(transactionConfig);
        transactionConfig.setFactory(this.getTransactionFactory());
        builder.chain(new MessageProcessor[]{txProcessor});
        for (Object processor : this.messageProcessors) {
            if (processor instanceof MessageProcessor) {
                builder.chain(new MessageProcessor[]{(MessageProcessor)processor});
                continue;
            }
            if (processor instanceof MessageProcessorBuilder) {
                builder.chain(new MessageProcessorBuilder[]{(MessageProcessorBuilder)processor});
                continue;
            }
            throw new IllegalArgumentException("MessageProcessorBuilder should only have MessageProcessor's or MessageProcessorBuilder's configured");
        }
        return MessageProcessors.lifecyleAwareMessageProcessorWrapper((MessageProcessor)builder.build());
    }

    protected TransactionFactory getTransactionFactory() {
        return new DelegateTransactionFactory();
    }

    protected MuleTransactionConfig createTransactionConfig(String action) {
        MuleTransactionConfig transactionConfig = new MuleTransactionConfig();
        transactionConfig.setActionAsString(action);
        return transactionConfig;
    }

    public boolean isSingleton() {
        return false;
    }

    public void setExceptionListener(MessagingExceptionHandler exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public void setAction(String action) {
        this.action = action;
    }
}

