/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.specific;

import org.mule.config.spring.factories.SimpleServiceFactoryBean;
import org.mule.config.spring.parsers.processors.CheckExclusiveAttributes;
import org.mule.config.spring.parsers.processors.CheckExclusiveAttributesAndChildren;
import org.mule.config.spring.parsers.specific.AbstractFlowConstructDefinitionParser;
import org.mule.util.StringUtils;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleServiceDefinitionParser
extends AbstractFlowConstructDefinitionParser {
    private static final String COMPONENT_CLASS_ATTRIBUTE = "component-class";
    private static final String COMPONENT_REF_ATTRIBUTE = "component-ref";
    private static final String COMPONENT_CHILD_TYPE = "componentType";
    private static final String ABSTRACT_ATTRIBUTE = "abstract";

    public SimpleServiceDefinitionParser() {
        super.addAlias("endpoint", "endpointBuilder");
        super.registerPreProcessor(new CheckExclusiveAttributes(new String[][]{{"address"}, {"endpoint-ref"}}));
        super.registerPreProcessor(new CheckExclusiveAttributes(new String[][]{{COMPONENT_CLASS_ATTRIBUTE}, {COMPONENT_REF_ATTRIBUTE}}));
        super.registerPreProcessor(new CheckExclusiveAttributesAndChildren(new String[]{"endpoint-ref", "address", "transformer-refs", "responseTransformer-refs"}, new String[]{"inbound-endpoint"}));
        super.registerPreProcessor(new CheckExclusiveAttributesAndChildren(new String[]{ABSTRACT_ATTRIBUTE}, new String[]{COMPONENT_CHILD_TYPE}));
    }

    @Override
    protected Class<?> getBeanClass(Element element) {
        return SimpleServiceFactoryBean.class;
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String componentRefAttribute = element.getAttribute(COMPONENT_REF_ATTRIBUTE);
        if (StringUtils.isNotBlank((String)componentRefAttribute)) {
            builder.addPropertyValue("componentBeanName", (Object)componentRefAttribute);
        }
        element.removeAttribute(COMPONENT_REF_ATTRIBUTE);
        super.doParse(element, parserContext, builder);
    }
}

