/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.factories;

import java.util.List;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorBuilder;
import org.mule.api.routing.filter.Filter;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.routing.MessageProcessorFilterPair;
import org.mule.routing.filters.AcceptAllFilter;
import org.mule.routing.filters.ExpressionFilter;
import org.springframework.beans.factory.FactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageProcessorFilterPairFactoryBean
implements FactoryBean,
MuleContextAware {
    private List<MessageProcessor> messageProcessors;
    private Filter filter = new ExpressionFilter();

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public void setMessageProcessors(List<MessageProcessor> messageProcessors) {
        this.messageProcessors = messageProcessors;
    }

    public void setExpression(String expression) {
        ((ExpressionFilter)this.filter).setExpression(expression);
    }

    public void setEvaluator(String evaluator) {
        ((ExpressionFilter)this.filter).setEvaluator(evaluator);
    }

    public void setCustomEvaluator(String customEvaluator) {
        ((ExpressionFilter)this.filter).setCustomEvaluator(customEvaluator);
    }

    public Object getObject() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        for (MessageProcessor processor : this.messageProcessors) {
            if (processor instanceof MessageProcessor) {
                builder.chain(new MessageProcessor[]{processor});
                continue;
            }
            if (processor instanceof MessageProcessorBuilder) {
                builder.chain(new MessageProcessorBuilder[]{(MessageProcessorBuilder)processor});
                continue;
            }
            throw new IllegalArgumentException("MessageProcessorBuilder should only have MessageProcessor's or MessageProcessorBuilder's configured");
        }
        return this.filter == null ? new MessageProcessorFilterPair((MessageProcessor)builder.build(), (Filter)AcceptAllFilter.INSTANCE) : new MessageProcessorFilterPair((MessageProcessor)builder.build(), this.filter);
    }

    public Class<?> getObjectType() {
        return MessageProcessorFilterPair.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setMuleContext(MuleContext context) {
        if (this.filter != null && this.filter instanceof MuleContextAware) {
            ((MuleContextAware)this.filter).setMuleContext(context);
        }
    }
}

