/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.specific.endpoint.support;

import org.mule.config.spring.parsers.generic.AutoIdUtils;
import org.mule.config.spring.parsers.generic.ChildDefinitionParser;
import org.mule.config.spring.parsers.specific.endpoint.support.EndpointUtils;
import org.mule.util.StringUtils;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.w3c.dom.Element;

public class ChildEndpointDefinitionParser
extends ChildDefinitionParser {
    public ChildEndpointDefinitionParser(Class endpoint) {
        super("messageProcessor", endpoint);
        this.addIgnored("ref");
        EndpointUtils.addProperties(this);
        EndpointUtils.addPostProcess(this);
    }

    public BeanDefinitionBuilder createBeanDefinitionBuilder(Element element, Class beanClass) {
        BeanDefinitionBuilder builder = super.createBeanDefinitionBuilder(element, beanClass);
        String global = element.getAttribute("ref");
        if (StringUtils.isNotBlank((String)global)) {
            builder.addConstructorArgReference(global);
            builder.addDependsOn(global);
        }
        return builder;
    }

    public String getPropertyName(Element e) {
        String parent = e.getParentNode().getLocalName().toLowerCase();
        if (e.getLocalName() != null && e.getLocalName().toLowerCase().endsWith("inbound-endpoint")) {
            return "messageSource";
        }
        if ("wire-tap".equals(parent) || "wire-tap-router".equals(parent)) {
            return "tap";
        }
        if ("binding".equals(parent) || "java-interface-binding".equals(parent) || "publish-notifications".equals(parent) || "remote-dispatcher-agent".equals(parent)) {
            return "endpoint";
        }
        return super.getPropertyName(e);
    }

    public String getBeanName(Element element) {
        if (null != element.getAttributeNode("ref")) {
            return AutoIdUtils.uniqueValue("ref:" + element.getAttribute("ref"));
        }
        return super.getBeanName(element);
    }
}

