/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.editors;

import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;

public class QNamePropertyEditor
extends PropertyEditorSupport {
    private boolean explicit = false;

    public QNamePropertyEditor() {
    }

    public QNamePropertyEditor(boolean explicit) {
        this();
        this.explicit = explicit;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (text.startsWith("qname{")) {
            this.setValue(this.parseQName(text.substring(6, text.length() - 1)));
        } else if (!this.explicit) {
            this.setValue(this.parseQName(text));
        } else {
            this.setValue(new QName(text));
        }
    }

    protected QName parseQName(String val) {
        StringTokenizer st = new StringTokenizer(val, ":");
        ArrayList<String> elements = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            elements.add(st.nextToken());
        }
        switch (elements.size()) {
            case 1: {
                return new QName((String)elements.get(0));
            }
            case 2: {
                return new QName((String)elements.get(0), (String)elements.get(1));
            }
            case 3: {
                return new QName((String)elements.get(1) + ":" + (String)elements.get(2), (String)elements.get(0));
            }
            case 4: {
                return new QName((String)elements.get(2) + ":" + (String)elements.get(3), (String)elements.get(1), (String)elements.get(0));
            }
        }
        return null;
    }

    public static QName convert(String value) {
        QNamePropertyEditor editor = new QNamePropertyEditor();
        editor.setAsText(value);
        return (QName)editor.getValue();
    }
}

