/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.specific.endpoint.support;

import org.mule.config.spring.parsers.generic.AutoIdUtils;
import org.mule.config.spring.parsers.generic.ChildDefinitionParser;
import org.mule.config.spring.parsers.specific.endpoint.support.EndpointUtils;
import org.mule.util.StringUtils;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class ChildEndpointDefinitionParser
extends ChildDefinitionParser {
    public ChildEndpointDefinitionParser(Class endpoint) {
        super("endpoint", endpoint);
        this.addIgnored("ref");
        EndpointUtils.addProperties(this);
        EndpointUtils.addPostProcess(this);
    }

    public BeanDefinitionBuilder createBeanDefinitionBuilder(Element element, Class beanClass) {
        BeanDefinitionBuilder builder = super.createBeanDefinitionBuilder(element, beanClass);
        String global = element.getAttribute("ref");
        if (StringUtils.isNotBlank((String)global)) {
            builder.addConstructorArgReference(global);
            builder.addDependsOn(global);
        }
        return builder;
    }

    public String getBeanName(Element element) {
        if (null != element.getAttributeNode("ref")) {
            return AutoIdUtils.uniqueValue("ref:" + element.getAttribute("ref"));
        }
        return super.getBeanName(element);
    }

    protected void parseChild(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        if (element.getParentNode().getNodeName().equals("chaining-router") || element.getParentNode().getNodeName().equals("exception-based-router")) {
            builder.addPropertyValue("remoteSync", (Object)Boolean.TRUE);
        }
        super.parseChild(element, parserContext, builder);
    }
}

