/*
 * Decompiled with CFR 0.152.
 */
package org.mule.components.script.jsr223;

import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Namespace;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.mule.components.builder.AbstractMessageBuilder;
import org.mule.components.builder.MessageBuilderException;
import org.mule.components.script.jsr223.Scriptable;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOMessage;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.RecoverableException;

public class ScriptMessageBuilder
extends AbstractMessageBuilder
implements Initialisable {
    protected Scriptable scriptable = new Scriptable();

    public Object buildMessage(UMOMessage request, UMOMessage response) throws MessageBuilderException {
        Namespace namespace = this.scriptable.getScriptEngine().createNamespace();
        this.populateNamespace(namespace, request, response);
        Object result = null;
        try {
            result = this.runScript(namespace);
        }
        catch (ScriptException e) {
            throw new MessageBuilderException(response, (Throwable)e);
        }
        if (result == null) {
            throw new NullPointerException("A result payload must be returned from the groovy script");
        }
        return result;
    }

    public void initialise() throws InitialisationException, RecoverableException {
        this.scriptable.initialise();
    }

    protected void populateNamespace(Namespace namespace, UMOMessage request, UMOMessage response) {
        namespace.put((Object)"request", (Object)request);
        namespace.put((Object)"response", (Object)response);
        namespace.put((Object)"descriptor", (Object)this.descriptor);
        namespace.put((Object)"componentNamespace", (Object)namespace);
        namespace.put((Object)"log", (Object)this.logger);
    }

    public ScriptEngine getScriptEngine() {
        return this.scriptable.getScriptEngine();
    }

    public void setScriptEngine(ScriptEngine scriptEngine) {
        this.scriptable.setScriptEngine(scriptEngine);
    }

    public CompiledScript getCompiledScript() {
        return this.scriptable.getCompiledScript();
    }

    public void setCompiledScript(CompiledScript compiledScript) {
        this.scriptable.setCompiledScript(compiledScript);
    }

    public String getScriptText() {
        return this.scriptable.getScriptText();
    }

    public void setScriptText(String scriptText) {
        this.scriptable.setScriptText(scriptText);
    }

    public String getScriptFile() {
        return this.scriptable.getScriptFile();
    }

    public void setScriptFile(String scriptFile) {
        this.scriptable.setScriptFile(scriptFile);
    }

    public void setScriptEngineName(String scriptEngineName) {
        this.scriptable.setScriptEngineName(scriptEngineName);
    }

    protected void populateNamespace(Namespace namespace, UMOEventContext context) {
        namespace.put((Object)"context", (Object)context);
        namespace.put((Object)"message", (Object)context.getMessage());
        namespace.put((Object)"descriptor", (Object)context.getComponentDescriptor());
        namespace.put((Object)"componentNamespace", (Object)namespace);
        namespace.put((Object)"log", (Object)this.logger);
        namespace.put((Object)"result", new Object());
    }

    protected void compileScript(Compilable compilable) throws ScriptException {
        this.scriptable.compileScript(compilable);
    }

    protected Object evaluteScript(Namespace namespace) throws ScriptException {
        return this.scriptable.evaluteScript(namespace);
    }

    protected Object runScript(Namespace namespace) throws ScriptException {
        return this.scriptable.runScript(namespace);
    }

    protected ScriptEngine createScriptEngine() {
        return this.scriptable.createScriptEngine();
    }
}

